/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titanium.graph.clustering.BaseCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class RegexpCluster
extends BaseCluster {
    private List<Matcher> matchers;
    private Map<String, Set<NodeDescriptor>> mapPatternCluster;
    private Map<NodeDescriptor, List<String>> mapNodeMatching;

    public RegexpCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph) {
        this.moduleGraph = graph;
        this.successful = true;
        this.clusters = new HashSet();
        this.mapNameCluster = new HashMap();
    }

    private boolean createMatchers() {
        this.matchers = new ArrayList<Matcher>();
        this.mapPatternCluster = new HashMap<String, Set<NodeDescriptor>>();
        String stringList = Platform.getPreferencesService().getString("org.eclipse.titanium", "Graph_Regexp_Clusters", "", null);
        List splittedList = ResourceExclusionHelper.intelligentSplit((String)stringList, (char)'#', (char)'\\');
        if (splittedList.isEmpty()) {
            this.setErronous("No regular expressions were defined.\nPlease visit the 'Clusters' Preference page to define them.");
            return false;
        }
        for (String item : splittedList) {
            try {
                Pattern pattern = Pattern.compile(item);
                HashSet cluster = new HashSet();
                this.mapPatternCluster.put(pattern.toString(), cluster);
                Matcher matcher = pattern.matcher("");
                this.matchers.add(matcher);
            }
            catch (PatternSyntaxException e) {
                String errorString = "At least one of the regular expressions used is not correct.\nPlease visit the 'Clusters' Preference page to correct it.\nReason: " + e.getLocalizedMessage() + "\n" + "Incorrect pattern: " + item;
                ErrorReporter.logExceptionStackTrace((String)errorString, (Throwable)e);
                this.setErronous(errorString);
                return false;
            }
        }
        return true;
    }

    private void collectMatchingNodes(IProgressMonitor progress) {
        this.mapNodeMatching = new HashMap<NodeDescriptor, List<String>>();
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            String name = v.getDisplayName();
            progress.subTask("Checking " + name);
            LinkedList<String> matching = new LinkedList<String>();
            for (Matcher matcher : this.matchers) {
                matcher.reset(name);
                if (!matcher.matches()) continue;
                matching.add(matcher.pattern().toString());
            }
            this.mapNodeMatching.put(v, matching);
        }
    }

    private void clearPrevClusters() {
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            v.setCluster(null);
        }
    }

    private boolean fillClusters() {
        HashSet<NodeDescriptor> missing = new HashSet<NodeDescriptor>();
        this.mapPatternCluster.put("missing", missing);
        boolean moreThanOneMatch = false;
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            List<String> matching = this.mapNodeMatching.get(v);
            if (matching.isEmpty()) {
                missing.add(v);
                v.setCluster(missing);
                continue;
            }
            if (matching.size() == 1) {
                Set<NodeDescriptor> cluster = this.mapPatternCluster.get(matching.get(0));
                cluster.add(v);
                v.setCluster(cluster);
                continue;
            }
            moreThanOneMatch = true;
            StringBuilder message = new StringBuilder(this.msg);
            message.append(v.getDisplayName()).append(":\t");
            for (String pattern : matching) {
                message.append("   ").append(pattern);
            }
            message.append('\n');
            this.msg = message.toString();
        }
        return moreThanOneMatch;
    }

    private void addClusters() {
        for (Map.Entry<String, Set<NodeDescriptor>> entry : this.mapPatternCluster.entrySet()) {
            String name = entry.getKey();
            Set<NodeDescriptor> cluster = entry.getValue();
            if (cluster.isEmpty()) continue;
            this.mapNameCluster.put(name, cluster);
            this.clusters.add(cluster);
        }
    }

    @Override
    public boolean createClusters(IProgressMonitor monitor) {
        IProgressMonitor progress = monitor == null ? new NullProgressMonitor() : monitor;
        progress.beginTask("Creating clusters", 3 + this.moduleGraph.getVertexCount());
        progress.subTask("Cheking patterns");
        if (this.createMatchers()) {
            progress.worked(1);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
        } else {
            progress.done();
            return false;
        }
        this.clearPrevClusters();
        this.collectMatchingNodes(progress);
        progress.worked(1);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.subTask("Creating clusters from gathered information");
        boolean moreThanOneMatch = this.fillClusters();
        if (moreThanOneMatch) {
            this.msg = "At least one module name matches more than one regular expressions.\nPlease visit the 'Clusters' Preference page to correct it.\nThe following modules have too many matches:\n" + this.msg;
            this.setErronous(this.msg);
            return false;
        }
        this.addClusters();
        progress.worked(1);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.done();
        if (this.clusters.size() < 2) {
            this.setErronous("Less than two clusters were found.\nThe settings might not be correct or no matches were found.");
            return false;
        }
        return true;
    }

    @Override
    protected void reportError() {
        this.errorHandler.reportBadSetting("Clustering failure", this.msg, "Open Clustering Preferences", "org.eclipse.titanium.preferences.pages.GraphClusterRegexpPage");
    }

    @Override
    protected String getType() {
        return "Clustering using regural expressions";
    }
}

