/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Composite<T>
extends Glyph {
    private ArrayList<Glyph> children;
    private transient double[] bbox;

    public Composite() {
        this.vx = 0.0;
        this.vy = 0.0;
        this.children = new ArrayList();
        this.bbox = new double[4];
    }

    public void addChild(Glyph child) {
        this.children.add(child);
        this.computeBounds();
    }

    public boolean removeChild(Glyph child) {
        boolean removed = this.children.remove(child);
        if (removed) {
            this.computeBounds();
        }
        return removed;
    }

    public List<Glyph> peekAtChildren() {
        return this.children;
    }

    @Override
    public double[] getBounds() {
        double[] retval = new double[this.bbox.length];
        System.arraycopy(this.bbox, 0, retval, 0, this.bbox.length);
        return retval;
    }

    @Override
    public Composite clone() {
        Composite retval = (Composite)super.clone();
        retval.children = new ArrayList();
        for (Glyph g : this.children) {
            retval.children.add((Glyph)g.clone());
        }
        return retval;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return 0;
    }

    @Override
    public void resetMouseIn() {
    }

    @Override
    public void resetMouseIn(int i) {
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return true;
    }

    @Override
    public void removeCamera(int index) {
        for (Glyph child : this.children) {
            child.removeCamera(index);
        }
    }

    @Override
    public void addCamera(int index) {
        for (Glyph child : this.children) {
            child.addCamera(index);
        }
    }

    @Override
    public void initCams(int nbCam) {
        for (Glyph child : this.children) {
            child.initCams(nbCam);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        for (Glyph child : this.children) {
            child.drawForLens(g, vW, vH, i, stdS, stdT, dx, dy);
        }
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        for (Glyph child : this.children) {
            child.draw(g, vW, vH, i, stdS, stdT, dx, dy);
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        for (Glyph child : this.children) {
            child.projectForLens(c, lensWidth, lensHeight, lensMag, lensx, lensy);
        }
    }

    @Override
    public void project(Camera c, Dimension d) {
        for (Glyph child : this.children) {
            child.project(c, d);
        }
    }

    @Override
    public void highlight(boolean b, Color selectedColor) {
        for (Glyph g : this.children) {
            g.highlight(b, selectedColor);
        }
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getOrient() {
        return 0.0;
    }

    @Override
    public void reSize(double factor) {
        for (Glyph child : this.children) {
            child.reSize(factor);
            child.move((this.vx - child.vx) * (1.0 - factor), (this.vy - child.vy) * (1.0 - factor));
        }
        this.computeBounds();
    }

    @Override
    public void sizeTo(double newSize) {
        this.reSize(newSize / this.getSize());
    }

    @Override
    public void move(double dx, double dy) {
        this.vx += dx;
        this.vy += dy;
        for (Glyph child : this.children) {
            child.move(dx, dy);
        }
        this.translateBoundingBox(dx, dy);
    }

    @Override
    public void moveTo(double x, double y) {
        this.move(x - this.vx, y - this.vy);
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        double vw = (this.bbox[2] - this.bbox[0]) / 2.0;
        double vh = (this.bbox[1] - this.bbox[3]) / 2.0;
        double cx = this.bbox[0] + vw;
        double cy = this.bbox[3] + vh;
        return cx - vw <= eb && cx + vw >= wb && cy - vh <= nb && cy + vh >= sb;
    }

    private void translateBoundingBox(double dx, double dy) {
        this.bbox[0] = this.bbox[0] + dx;
        this.bbox[1] = this.bbox[1] + dy;
        this.bbox[2] = this.bbox[2] + dx;
        this.bbox[3] = this.bbox[3] + dy;
    }

    public void computeBounds() {
        this.bbox[0] = Double.MAX_VALUE;
        this.bbox[1] = Double.MIN_VALUE;
        this.bbox[2] = Double.MIN_VALUE;
        this.bbox[3] = Double.MAX_VALUE;
        for (Glyph child : this.children) {
            double[] glBounds = child.getBounds();
            if (glBounds[0] < this.bbox[0]) {
                this.bbox[0] = glBounds[0];
            }
            if (glBounds[1] > this.bbox[1]) {
                this.bbox[1] = glBounds[1];
            }
            if (glBounds[2] > this.bbox[2]) {
                this.bbox[2] = glBounds[2];
            }
            if (!(glBounds[3] < this.bbox[3])) continue;
            this.bbox[3] = glBounds[3];
        }
    }

    @Override
    public double getSize() {
        return Math.sqrt((this.bbox[1] - this.bbox[3]) * (this.bbox[1] - this.bbox[3]) + (this.bbox[2] - this.bbox[0]) * (this.bbox[2] - this.bbox[0]));
    }

    @Override
    public Shape getJava2DShape() {
        return null;
    }
}

