/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xtype.XImportDeclaration;

public class StaticallyImportedMemberProvider {
    @Inject
    @Extension
    private IImportsConfiguration _iImportsConfiguration;
    @Inject
    @Extension
    private IResolvedFeatures.Provider _provider;
    @Inject
    private IVisibilityHelper visibilityHelper;

    public Iterable<JvmFeature> findAllFeatures(final XImportDeclaration it) {
        Iterable _xblockexpression = null;
        JvmDeclaredType importedType = it.getImportedType();
        if (!it.isStatic() || Objects.equal((Object)importedType, null)) {
            return CollectionLiterals.emptyList();
        }
        Resource _eResource = it.eResource();
        final IVisibilityHelper visibilityHelper = this.getVisibilityHelper(_eResource);
        IResolvedFeatures resolvedFeatures = this._provider.getResolvedFeatures((JvmType)importedType);
        List<JvmFeature> _allFeatures = resolvedFeatures.getAllFeatures();
        Functions.Function1<JvmFeature, Boolean> _function = new Functions.Function1<JvmFeature, Boolean>(){

            public Boolean apply(JvmFeature feature) {
                return feature.isStatic() && visibilityHelper.isVisible((JvmMember)feature) && (Objects.equal((Object)it.getMemberName(), null) || feature.getSimpleName().startsWith(it.getMemberName()));
            }
        };
        _xblockexpression = IterableExtensions.filter(_allFeatures, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public Iterable<JvmFeature> getAllFeatures(XImportDeclaration it) {
        Resource _eResource = it.eResource();
        JvmDeclaredType _importedType = it.getImportedType();
        boolean _isStatic = it.isStatic();
        boolean _isExtension = it.isExtension();
        String _memberName = it.getMemberName();
        return this.getAllFeatures(_eResource, _importedType, _isStatic, _isExtension, _memberName);
    }

    public Iterable<JvmFeature> getAllFeatures(Resource resource, JvmDeclaredType importedType, boolean static_, boolean extension, String memberName) {
        Iterable _xblockexpression = null;
        if (!static_ || Objects.equal((Object)importedType, null)) {
            return CollectionLiterals.emptyList();
        }
        final IVisibilityHelper visibilityHelper = this.getVisibilityHelper(resource);
        IResolvedFeatures resolvedFeatures = this._provider.getResolvedFeatures((JvmType)importedType);
        List<JvmFeature> _allFeatures = resolvedFeatures.getAllFeatures(memberName);
        Functions.Function1<JvmFeature, Boolean> _function = new Functions.Function1<JvmFeature, Boolean>(){

            public Boolean apply(JvmFeature feature) {
                return feature.isStatic() && visibilityHelper.isVisible((JvmMember)feature);
            }
        };
        _xblockexpression = IterableExtensions.filter(_allFeatures, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public IVisibilityHelper getVisibilityHelper(Resource resource) {
        IVisibilityHelper _switchResult = null;
        boolean _matched = false;
        if (resource instanceof XtextResource) {
            _matched = true;
            IVisibilityHelper _xblockexpression = null;
            String packageName = this._iImportsConfiguration.getPackageName((XtextResource)resource);
            IVisibilityHelper _xifexpression = null;
            boolean _equals = Objects.equal((Object)packageName, null);
            _xifexpression = _equals ? this.visibilityHelper : new ContextualVisibilityHelper(this.visibilityHelper, packageName);
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched) {
            _switchResult = this.visibilityHelper;
        }
        return _switchResult;
    }
}

