/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.texteditor.AnnotationType;

public final class AnnotationTypeHierarchy {
    private Map<String, String> fTypeMap;
    private Map<String, AnnotationType> fTypesCache = new HashMap<String, AnnotationType>();

    public AnnotationType getAnnotationType(String typeName) {
        AnnotationType type = this.fTypesCache.get(typeName);
        if (type == null) {
            String[] superTypes = this.computeSuperTypes(typeName);
            type = new AnnotationType(typeName, superTypes);
            this.fTypesCache.put(typeName, type);
        }
        return type;
    }

    public boolean isSubtype(String superType, String subtypeCandidate) {
        AnnotationType type = this.getAnnotationType(subtypeCandidate);
        return type.isSubtype(superType);
    }

    private String[] computeSuperTypes(String typeName) {
        ArrayList<String> types = new ArrayList<String>();
        this.append(types, this.getDirectSuperType(typeName));
        int index = 0;
        while (index < types.size()) {
            String type = types.get(index++);
            this.append(types, this.getDirectSuperType(type));
        }
        String[] superTypes = new String[types.size()];
        types.toArray(superTypes);
        return superTypes;
    }

    private String getDirectSuperType(String typeName) {
        return this.getTypeMap().get(typeName);
    }

    private void append(List<String> list, String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    private Map<String, String> getTypeMap() {
        if (this.fTypeMap == null) {
            this.fTypeMap = this.readTypes();
        }
        return this.fTypeMap;
    }

    private Map<String, String> readTypes() {
        HashMap<String, String> allTypes = new HashMap<String, String>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "annotationTypes");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                String name = element.getAttribute("name");
                if (name != null && name.trim().length() != 0) {
                    String parent = element.getAttribute("super");
                    if (parent == null || parent.trim().length() == 0) {
                        parent = "";
                    }
                    allTypes.put(name, parent);
                }
                ++i;
            }
        }
        return allTypes;
    }
}

