/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.text.AbstractKeyValueTextChangeListener;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.util.PropertiesUtil;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class BundleTextChangeListener
extends AbstractKeyValueTextChangeListener {
    public BundleTextChangeListener(IDocument document) {
        super(document, false);
    }

    public BundleTextChangeListener(IDocument document, boolean generateReadableNames) {
        super(document, generateReadableNames);
    }

    @Override
    public TextEdit[] getTextOperations() {
        TextEdit[] ops = super.getTextOperations();
        try {
            if (ops.length == 0 || !PropertiesUtil.isNewlineNeeded(this.fDocument)) {
                return ops;
            }
        }
        catch (BadLocationException badLocationException) {}
        TextEdit[] result = new TextEdit[ops.length + 1];
        result[ops.length] = new InsertEdit(PropertiesUtil.getInsertOffset(this.fDocument), this.fSep);
        if (this.fReadableNames != null) {
            this.fReadableNames.put(result[ops.length], PDECoreMessages.BundleTextChangeListener_editNames_newLine);
        }
        System.arraycopy(ops, 0, result, 0, ops.length);
        return result;
    }

    @Override
    protected void insertKey(IDocumentKey key, String name) {
        int offset = PropertiesUtil.getInsertOffset(this.fDocument);
        StringBuilder buffer = new StringBuilder(key.write());
        try {
            if (PropertiesUtil.isNewlineNeeded(this.fDocument) && buffer.substring(buffer.length() - this.fSep.length()).equals(this.fSep)) {
                buffer.insert(0, this.fSep);
                buffer.setLength(buffer.length() - this.fSep.length());
            }
        }
        catch (BadLocationException badLocationException) {}
        InsertEdit edit = new InsertEdit(offset, buffer.toString());
        this.fOperationTable.put(key, edit);
        if (this.fReadableNames != null) {
            this.fReadableNames.put(edit, name);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void modelChanged(IModelChangedEvent event) {
        Object[] objectArray = event.getChangedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object changedObject = objectArray[n2];
            Object object = changedObject;
            if (object instanceof PDEManifestElement) {
                object = ((PDEManifestElement)object).getHeader();
            } else if (object instanceof PackageFriend) {
                object = ((PackageFriend)object).getHeader();
            }
            Object object2 = object;
            if (object2 instanceof ManifestHeader) {
                void header;
                ManifestHeader cfr_ignored_0 = (ManifestHeader)object2;
                ManifestHeader cfr_ignored_1 = (ManifestHeader)object2;
                Object op = this.fOperationTable.remove(header);
                if (this.fReadableNames != null) {
                    this.fReadableNames.remove(op);
                }
                if (header.getValue() == null || header.getValue().trim().length() == 0) {
                    name = this.fReadableNames == null ? null : NLS.bind((String)PDECoreMessages.BundleTextChangeListener_editNames_remove, (Object)header.fName);
                    this.deleteKey((IDocumentKey)header, name);
                } else {
                    name = this.fReadableNames == null ? null : NLS.bind((String)(header.getOffset() == -1 ? PDECoreMessages.BundleTextChangeListener_editNames_insert : PDECoreMessages.BundleTextChangeListener_editNames_modify), (Object)header.fName);
                    this.modifyKey((IDocumentKey)header, name);
                }
            }
            ++n2;
        }
    }
}

