/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaProvider;

public class SchemaDescriptor
implements ISchemaDescriptor {
    private String fPoint;
    private URL fSchemaURL;
    private Schema fSchema;
    private long fLastModified;
    private boolean fEditable;
    private SchemaProvider schemaProvider;

    public SchemaDescriptor(String extPointID, URL schemaURL) {
        this(extPointID, schemaURL, null);
    }

    public SchemaDescriptor(String extPointID, URL schemaURL, SchemaProvider provider) {
        File file;
        this.fPoint = extPointID;
        this.fSchemaURL = schemaURL;
        if (this.fSchemaURL != null && (file = new File(this.fSchemaURL.getFile())).exists()) {
            this.fLastModified = file.lastModified();
        }
        this.schemaProvider = provider;
    }

    public SchemaDescriptor(IFile file, boolean editable) {
        this(new File(file.getLocation().toOSString()));
        this.fEditable = editable;
    }

    public SchemaDescriptor(File file) {
        try {
            if (file.exists()) {
                this.fSchemaURL = file.toURL();
                this.fLastModified = file.lastModified();
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    @Override
    public String getPointId() {
        if (this.fPoint != null) {
            return this.fPoint;
        }
        return this.fSchema == null ? null : this.fSchema.getQualifiedPointId();
    }

    @Override
    public ISchema getSchema(boolean abbreviated) {
        if (this.fSchema == null && this.fSchemaURL != null) {
            this.fSchema = this.fEditable ? new EditableSchema(this, this.fSchemaURL, abbreviated) : new Schema(this, this.fSchemaURL, abbreviated);
            this.fSchema.setSchemaProvider(this.schemaProvider);
            this.fSchema.load();
        }
        return this.fSchema;
    }

    @Override
    public URL getSchemaURL() {
        return this.fSchemaURL;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public long getLastModified() {
        return this.fLastModified;
    }
}

