/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.util.CoreUtility;

class ExternalLibraryCache {
    private static final String LIB_CACHE_DIR = ".external_libraries";

    ExternalLibraryCache() {
    }

    public File[] getExtractedLibraries(IPluginModelBase model) {
        File fJarFile = new File(model.getInstallLocation());
        if (!fJarFile.isFile()) {
            return new File[0];
        }
        BundleDescription desc = model.getBundleDescription();
        IPluginLibrary[] libs = model.getPluginBase().getLibraries();
        File fCacheDir = new File(this.getLibraryCacheDir(), this.getBundleLibsCacheDirName(desc));
        ArrayList<File> files = new ArrayList<File>();
        IPluginLibrary[] iPluginLibraryArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary lib = iPluginLibraryArray[n2];
            String libName = lib.getName();
            if (!".".equals(libName)) {
                File fDestFile = new File(fCacheDir, libName = ClasspathUtilCore.expandLibraryName(libName));
                if (!fDestFile.isFile()) {
                    try {
                        File extractedLib = this.extractJar(fJarFile, libName, fDestFile);
                        if (extractedLib != null) {
                            files.add(extractedLib);
                        }
                    }
                    catch (IOException ie) {
                        PDECore.logException(ie, "Could not extract library from jarred bundle " + desc.getSymbolicName());
                    }
                } else {
                    files.add(fDestFile);
                }
            }
            ++n2;
        }
        return files.toArray(new File[0]);
    }

    public void cleanExtractedLibraries(IPluginModelBase[] targetModels) {
        File fCacheDir = this.getLibraryCacheDir();
        if (!fCacheDir.isDirectory()) {
            return;
        }
        HashSet<String> bundleKeys = new HashSet<String>();
        IPluginModelBase[] iPluginModelBaseArray = targetModels;
        int n = targetModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase targetModel = iPluginModelBaseArray[n2];
            if (targetModel.isEnabled()) {
                BundleDescription desc = targetModel.getBundleDescription();
                bundleKeys.add(this.getBundleLibsCacheDirName(desc));
            }
            ++n2;
        }
        File[] fDirs = fCacheDir.listFiles();
        int i = 0;
        while (i < fDirs.length) {
            if (fDirs[i].isDirectory() && !bundleKeys.contains(fDirs[i].getName())) {
                CoreUtility.deleteContent(fDirs[i]);
            }
            ++i;
        }
        fCacheDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPath getNestedLibrary(IPluginModelBase model, String path) {
        String installLocation = model.getInstallLocation();
        if (installLocation != null) {
            File location = new File(installLocation);
            if (location.isDirectory()) {
                File result = new File(location, path);
                return result.exists() ? IPath.fromOSString((String)result.getAbsolutePath()) : null;
            }
            if (location.isFile()) {
                BundleDescription desc = model.getBundleDescription();
                File fCacheDir = new File(this.getLibraryCacheDir(), this.getBundleLibsCacheDirName(desc));
                File fDestFile = new File(fCacheDir, path);
                ExternalLibraryCache externalLibraryCache = this;
                synchronized (externalLibraryCache) {
                    if (!fDestFile.exists()) {
                        File extractedLib = null;
                        try {
                            extractedLib = this.extractJar(location, path, fDestFile);
                        }
                        catch (IOException iOException) {}
                        if (extractedLib == null) {
                            try {
                                fDestFile.getParentFile().mkdirs();
                                fDestFile.createNewFile();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                return fDestFile.length() == 0L ? null : IPath.fromOSString((String)fDestFile.getAbsolutePath());
            }
        }
        return null;
    }

    private File getLibraryCacheDir() {
        IPath path = PDECore.getDefault().getStateLocation();
        return new File(path.toFile(), LIB_CACHE_DIR);
    }

    private String getBundleLibsCacheDirName(BundleDescription desc) {
        return desc.getSymbolicName() + "_" + String.valueOf(desc.getVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File extractJar(File fJarFile, String libName, File fTargetFile) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (JarFile f = new JarFile(fJarFile);){
            ZipEntry libEntry = f.getEntry(libName);
            if (libEntry == null) return null;
            if (libEntry.isDirectory()) {
                return null;
            }
            fTargetFile.getParentFile().mkdirs();
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (InputStream in = f.getInputStream(libEntry);){
                if (in == null) {
                    throw new IOException();
                }
                CoreUtility.readFile(in, fTargetFile);
                return fTargetFile;
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                    throw throwable2;
                }
                if (throwable2 == throwable3) throw throwable2;
                throwable2.addSuppressed(throwable3);
                throw throwable2;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }
}

