/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.validator.StringLengthValidator;
import com.sun.webui.theme.Theme;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;

public final class EditableList
extends WebuiInput
implements ListManager,
NamingContainer {
    public static final String ADD_BUTTON_ID = "_addButton";
    public static final String ADD_BUTTON_FACET = "addButton";
    public static final String ADD_BUTTON_TEXT_KEY = "EditableList.add";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String REMOVE_BUTTON_TEXT_KEY = "EditableList.remove";
    public static final String FIELD_ID = "_field";
    public static final String FIELD_FACET = "field";
    public static final String SLV_TOOLONG_KEY = "EditableList.itemTooLong";
    public static final String SLV_TOOSHORT_KEY = "EditableList.fieldEmpty";
    public static final String LIST_LABEL_ID = "_listLabel";
    public static final String LIST_LABEL_FACET = "listLabel";
    public static final String LIST_LABEL_TEXT_KEY = "EditableList.defaultListLabel";
    public static final String FIELD_LABEL_ID = "_fieldLabel";
    public static final String FIELD_LABEL_FACET = "fieldLabel";
    public static final String FIELD_LABEL_TEXT_KEY = "EditableList.defaultFieldLabel";
    public static final String READ_ONLY_ID = "_readOnly";
    public static final String READ_ONLY_FACET = "readOnly";
    public static final String HEADER_FACET = "header";
    public static final String FOOTER_FACET = "footer";
    public static final String ADD_FUNCTION = ".add(); ";
    public static final String ENABLE_ADD_FUNCTION = ".enableAdd(); ";
    public static final String SET_ADD_DISABLED_FUNCTION = ".setAddDisabled(false);";
    public static final String ENABLE_REMOVE_FUNCTION = ".enableRemove(); ";
    public static final String UPDATE_BUTTONS_FUNCTION = ".updateButtons(); ";
    private static final String READ_ONLY_SEPARATOR = ", ";
    public static final String SEARCH_FACET = "search";
    public static final String SPACER_STRING = "_";
    private static final String KEY_STRING = "a";
    private static final String DUP_STRING = "\t";
    private static final int MIN_LENGTH = 20;
    private static final boolean DEBUG = false;
    private TreeMap<String, ListItem> listItems = null;
    private Collator collator = null;
    private transient Theme theme = null;
    private String selectedValue = null;
    private String[] valuesToRemove = null;
    private boolean disabled = false;
    private boolean disabledSet = false;
    private String fieldLabel = null;
    private int labelLevel = Integer.MIN_VALUE;
    private boolean labelLevelSet = false;
    private String listLabel = null;
    private boolean listOnTop = false;
    private boolean listOnTopSet = false;
    private int maxLength = Integer.MIN_VALUE;
    private boolean maxLengthSet = false;
    private boolean multiple = false;
    private boolean multipleSet = false;
    private boolean readOnly = false;
    private boolean readOnlySet = false;
    private int rows = Integer.MIN_VALUE;
    private boolean rowsSet = false;
    private boolean sorted = false;
    private boolean sortedSet = false;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private String toolTip = null;
    private boolean visible = false;
    private boolean visibleSet = false;
    private MethodExpression fieldValidatorExpression;

    public EditableList() {
        this.setRendererType("com.sun.webui.jsf.EditableList");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.EditableList";
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    public boolean isImmediate() {
        return false;
    }

    public Object getValue() {
        return super.getValue();
    }

    public MethodExpression getListValidatorExpression() {
        return this.getValidatorExpression();
    }

    public void setListValidatorExpression(MethodExpression listValidator) {
        this.setValidatorExpression(listValidator);
    }

    @Override
    public MethodExpression getValidatorExpression() {
        return super.getValidatorExpression();
    }

    public Object getList() {
        return this.getValue();
    }

    public void setList(Object newList) {
        this.setValue(newList);
    }

    public int getMaxLength() {
        Object result;
        ValueExpression vb;
        int length = this.maxLengthSet ? this.maxLength : ((vb = this.getValueExpression("maxLength")) != null ? ((result = vb.getValue(this.getFacesContext().getELContext())) == null ? Integer.MIN_VALUE : (Integer)result) : 25);
        if (length < 1) {
            length = 25;
        }
        return length;
    }

    public UIComponent getAddButtonComponent() {
        return this.getButtonFacet(ADD_BUTTON_FACET, false, this.getTheme().getMessage(ADD_BUTTON_TEXT_KEY), new AddListener());
    }

    public UIComponent getRemoveButtonComponent() {
        return this.getButtonFacet(REMOVE_BUTTON_FACET, false, this.getTheme().getMessage(REMOVE_BUTTON_TEXT_KEY), new RemoveListener());
    }

    private UIComponent getButtonFacet(String facetName, boolean primary, String text, ActionListener actionListener) {
        UIComponent buttonComponent = this.getFacet(facetName);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            button.addActionListener(actionListener);
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        }
        this.initButtonFacet(button, primary, text);
        return button;
    }

    private void initButtonFacet(Button button, boolean primary, String text) {
        button.setText(text);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            button.setTabIndex(tindex);
        }
        button.setImmediate(true);
        button.setPrimary(primary);
        button.setDisabled(this.isDisabled());
    }

    public UIComponent getListLabelComponent() {
        String labelString = this.getListLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(LIST_LABEL_TEXT_KEY);
        }
        return this.getLabelFacet(LIST_LABEL_FACET, labelString, (UIComponent)this);
    }

    public UIComponent getFieldLabelComponent() {
        String labelString = this.getFieldLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(FIELD_LABEL_TEXT_KEY);
        }
        return this.getLabelFacet(FIELD_LABEL_FACET, labelString, this.getFieldComponent());
    }

    private UIComponent getLabelFacet(String facetName, String text, UIComponent forComponent) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        this.initLabelFacet(label, text, forComponent.getClientId(this.getFacesContext()));
        return label;
    }

    private void initLabelFacet(Label label, String labelString, String forComponentId) {
        if (labelString == null || labelString.length() < 1) {
            label.setText("");
        } else {
            label.setText(labelString);
        }
        label.setLabelLevel(this.getLabelLevel());
        if (!this.isReadOnly()) {
            label.setFor(forComponentId);
        }
    }

    private UIComponent getRenderedFieldComponent() {
        UIComponent fieldComponent = this.getFacet(FIELD_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        fieldComponent = ComponentUtilities.getPrivateFacet((UIComponent)this, FIELD_FACET, false);
        if (fieldComponent == null) {
            return this.getFieldComponent();
        }
        return fieldComponent;
    }

    public UIComponent getFieldComponent() {
        UIComponent fieldComponent = this.getFacet(FIELD_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FIELD_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FIELD_FACET));
            field.setTrim(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FIELD_FACET, (UIComponent)field);
            StringLengthValidator strl = new StringLengthValidator(this.getMaxLength(), 1);
            Theme th = this.getTheme();
            strl.setTooLongMessage(th.getMessage(SLV_TOOLONG_KEY));
            strl.setTooShortMessage(th.getMessage(SLV_TOOSHORT_KEY));
            field.addValidator(strl);
        }
        this.initFieldFacet(field);
        return field;
    }

    private void initFieldFacet(TextField field) {
        String jsObjectName = this.getJavaScriptObjectName();
        StringBuilder onkeypressBuffer = new StringBuilder();
        onkeypressBuffer.append("if(event.keyCode == 13) { ");
        onkeypressBuffer.append(jsObjectName);
        onkeypressBuffer.append(ADD_FUNCTION);
        onkeypressBuffer.append("return false; } ");
        field.setOnKeyPress(onkeypressBuffer.toString());
        StringBuilder onfocusBuffer = new StringBuilder();
        onfocusBuffer.append(jsObjectName);
        onfocusBuffer.append(SET_ADD_DISABLED_FUNCTION);
        onfocusBuffer.append("return false;");
        field.setOnFocus(onfocusBuffer.toString());
        StringBuilder onfocuslostBuffer = new StringBuilder();
        onfocuslostBuffer.append(jsObjectName);
        onfocuslostBuffer.append(ENABLE_ADD_FUNCTION);
        onfocuslostBuffer.append("return false;");
        field.setOnBlur(onfocuslostBuffer.toString());
        int columns = this.getMaxLength();
        if (columns < 20) {
            columns = 20;
        }
        field.setColumns(columns);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            field.setTabIndex(tindex);
        }
        field.setDisabled(this.isDisabled());
        field.setValidatorExpression(this.getFieldValidatorExpression());
    }

    @Override
    public UIComponent getReadOnlyValueComponent() {
        UIComponent textComponent = this.getFacet(READ_ONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READ_ONLY_FACET));
        text.setParent((UIComponent)this);
        FacesContext context = FacesContext.getCurrentInstance();
        String readOnlyString = this.getValueAsReadOnly(context);
        if (readOnlyString == null || readOnlyString.length() < 1) {
            readOnlyString = new String();
        }
        text.setText(readOnlyString);
        return text;
    }

    private String getValueAsReadOnly(FacesContext context) throws FacesException {
        StringBuilder valueBuffer = new StringBuilder();
        Iterator iterator = this.getListItems(context, false);
        while (iterator.hasNext()) {
            String string = ((ListItem)iterator.next()).getLabel();
            if (string.contains("nbsp")) continue;
            valueBuffer.append(string);
            if (!iterator.hasNext()) continue;
            valueBuffer.append(READ_ONLY_SEPARATOR);
        }
        return valueBuffer.toString();
    }

    @Override
    public void setConverter(Converter converter) {
        String msg = this.getTheme().getMessage("EditableList.noConversion");
        throw new RuntimeException(msg);
    }

    public String getJavaScriptObjectName() {
        return JavaScriptUtilities.getDomNode(this.getFacesContext(), (UIComponent)this);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    @Override
    public String getOnChange() {
        StringBuilder onchangeBuffer = new StringBuilder();
        onchangeBuffer.append(this.getJavaScriptObjectName());
        onchangeBuffer.append(ENABLE_REMOVE_FUNCTION);
        return onchangeBuffer.toString();
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        if (this.isReadOnly()) {
            return null;
        }
        return this.getClientId(context).concat("_list");
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat("_list");
    }

    public String[] getValuesToRemove() {
        if (this.valuesToRemove == null) {
            return new String[0];
        }
        return this.valuesToRemove;
    }

    public void setValuesToRemove(String[] values) {
        this.valuesToRemove = values;
    }

    @Override
    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.listItems = new TreeMap(this.collator);
        boolean zSorted = this.isSorted();
        HashMap<String, String> keysSeen = zSorted ? new HashMap<String, String>() : null;
        String lastKey = "";
        String[] currentValues = this.getCurrentValueAsStringArray();
        ListItem selectedItem = null;
        StringBuilder unsortedKeyBuffer = zSorted ? null : new StringBuilder(KEY_STRING);
        for (int counter = 0; counter < currentValues.length; ++counter) {
            String currentString = currentValues[counter];
            if (currentString == null) {
                String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(context)});
                throw new FacesException(msg);
            }
            ListItem listItem = new ListItem(currentString);
            listItem.setValue(currentString);
            if (currentString.equals(this.selectedValue)) {
                selectedItem = listItem;
            }
            if (zSorted) {
                String key = currentString;
                if (keysSeen.containsKey(key)) {
                    String dupString = (String)keysSeen.get(key);
                    dupString = dupString.concat(DUP_STRING);
                    key = key.concat(dupString);
                    keysSeen.put(currentString, dupString);
                } else {
                    keysSeen.put(key, DUP_STRING);
                }
                if (this.collator.compare(key, lastKey) > 0) {
                    lastKey = key;
                }
                this.listItems.put(key, listItem);
                continue;
            }
            this.listItems.put(unsortedKeyBuffer.toString(), listItem);
            unsortedKeyBuffer.append(KEY_STRING);
        }
        if (selectedItem != null) {
            selectedItem.setSelected(true);
        }
        if (!zSorted) {
            lastKey = unsortedKeyBuffer.toString();
        }
        if (rulerAtEnd) {
            int length = this.getMaxLength();
            if (length < 20) {
                length = 20;
            }
            StringBuilder labelBuffer = new StringBuilder(length);
            for (int counter = 0; counter < length; ++counter) {
                labelBuffer.append(SPACER_STRING);
            }
            ListItem item = new ListItem(labelBuffer.toString());
            item.setDisabled(true);
            this.listItems.put(lastKey.concat(KEY_STRING), item);
        }
        return this.listItems.values().iterator();
    }

    private String[] getCurrentValueAsStringArray() {
        Object value = this.getSubmittedValue();
        if (value == null) {
            value = this.getValue();
        }
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(FacesContext.getCurrentInstance())});
        throw new FacesException(msg);
    }

    private static void log(String msg) {
        LogUtil.finest(EditableList.class.getName() + "::" + msg);
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value must be a String array");
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 0 && ConversionUtilities.renderedNull((UIComponent)this)) {
            return null;
        }
        return submittedValue;
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        UIComponent field = this.getRenderedFieldComponent();
        String fieldId = field.getId();
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (fieldId != null && fieldId.equals(kid.getId())) continue;
            kid.processValidators(context);
        }
        this.checkValid(context);
    }

    public void processAddAction() {
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        String[] values = this.getCurrentValueAsStringArray();
        Object value = this.getAddedObject();
        if (value == null) {
            return;
        }
        this.selectedValue = value.toString();
        int numValues = values.length;
        String[] newValues = new String[numValues + 1];
        for (int counter = 0; counter < numValues; ++counter) {
            newValues[counter] = values[counter];
        }
        newValues[counter] = this.selectedValue;
        this.setSubmittedValue(newValues);
    }

    public void processRemoveAction() {
        int counter;
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        ArrayList<String> items = new ArrayList<String>();
        if (this.getValue() != null) {
            String[] strings = this.getCurrentValueAsStringArray();
            int length = strings.length;
            for (counter = 0; counter < length; ++counter) {
                items.add(strings[counter]);
            }
        }
        String[] toRemove = this.getValuesToRemove();
        for (counter = 0; counter < toRemove.length; ++counter) {
            items.remove(toRemove[counter]);
        }
        String[] newValues = new String[items.size()];
        for (counter = 0; counter < items.size(); ++counter) {
            newValues[counter] = (String)items.get(counter);
        }
        this.setValuesToRemove(null);
        this.setSubmittedValue(newValues);
    }

    private void checkValid(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private Object getAddedObject() {
        FacesContext context = FacesContext.getCurrentInstance();
        EditableValueHolder field = (EditableValueHolder)this.getRenderedFieldComponent();
        ((UIComponent)field).processValidators(context);
        if (!field.isValid()) {
            return null;
        }
        Object value = field.getValue();
        if (value == null || value instanceof String && value.toString().length() == 0) {
            field.setValid(false);
            context.renderResponse();
            String message = ThemeUtilities.getTheme(context).getMessage(SLV_TOOSHORT_KEY);
            context.addMessage(this.getClientId(context), new FacesMessage(message));
            return null;
        }
        field.setValue(null);
        return value;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    @Override
    public String[] getValueAsStringArray(FacesContext context) {
        Iterator iterator = this.getListItems(context, false);
        int numItems = this.listItems.size();
        String[] values = new String[numItems];
        for (int counter = 0; counter < numItems; ++counter) {
            values[counter] = ((ListItem)iterator.next()).getValue();
        }
        return values;
    }

    @Override
    public boolean mainListSubmits() {
        return true;
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("list")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("list")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    @Override
    public boolean isDisabled() {
        if (this.disabledSet) {
            return this.disabled;
        }
        ValueExpression vb = this.getValueExpression("disabled");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setDisabled(boolean newDisabled) {
        this.disabled = newDisabled;
        this.disabledSet = true;
    }

    public String getFieldLabel() {
        if (this.fieldLabel != null) {
            return this.fieldLabel;
        }
        ValueExpression vb = this.getValueExpression(FIELD_LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFieldLabel(String newFieldLabel) {
        this.fieldLabel = newFieldLabel;
    }

    public int getLabelLevel() {
        if (this.labelLevelSet) {
            return this.labelLevel;
        }
        ValueExpression vb = this.getValueExpression("labelLevel");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 2;
    }

    public void setLabelLevel(int newLabelLevel) {
        this.labelLevel = newLabelLevel;
        this.labelLevelSet = true;
    }

    public String getListLabel() {
        if (this.listLabel != null) {
            return this.listLabel;
        }
        ValueExpression vb = this.getValueExpression(LIST_LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setListLabel(String newListLabel) {
        this.listLabel = newListLabel;
    }

    public boolean isListOnTop() {
        if (this.listOnTopSet) {
            return this.listOnTop;
        }
        ValueExpression vb = this.getValueExpression("listOnTop");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setListOnTop(boolean newListOnTop) {
        this.listOnTop = newListOnTop;
        this.listOnTopSet = true;
    }

    public void setMaxLength(int newMaxLength) {
        this.maxLength = newMaxLength;
        this.maxLengthSet = true;
    }

    @Override
    public boolean isMultiple() {
        if (this.multipleSet) {
            return this.multiple;
        }
        ValueExpression vb = this.getValueExpression("multiple");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMultiple(boolean newMultiple) {
        this.multiple = newMultiple;
        this.multipleSet = true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.readOnlySet) {
            return this.readOnly;
        }
        ValueExpression vb = this.getValueExpression(READ_ONLY_FACET);
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        this.readOnlySet = true;
    }

    @Override
    public int getRows() {
        if (this.rowsSet) {
            return this.rows;
        }
        ValueExpression vb = this.getValueExpression("rows");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 6;
    }

    public void setRows(int newRows) {
        this.rows = newRows;
        this.rowsSet = true;
    }

    public boolean isSorted() {
        if (this.sortedSet) {
            return this.sorted;
        }
        ValueExpression vb = this.getValueExpression("sorted");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSorted(boolean newSorted) {
        this.sorted = newSorted;
        this.sortedSet = true;
    }

    @Override
    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    @Override
    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    @Override
    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    @Override
    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    @Override
    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public MethodExpression getFieldValidatorExpression() {
        return this.fieldValidatorExpression;
    }

    public void setFieldValidatorExpression(MethodExpression newFieldValidatorExpression) {
        this.fieldValidatorExpression = newFieldValidatorExpression;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.disabled = (Boolean)values[1];
        this.disabledSet = (Boolean)values[2];
        this.fieldLabel = (String)values[3];
        this.labelLevel = (Integer)values[4];
        this.labelLevelSet = (Boolean)values[5];
        this.listLabel = (String)values[6];
        this.listOnTop = (Boolean)values[7];
        this.listOnTopSet = (Boolean)values[8];
        this.maxLength = (Integer)values[9];
        this.maxLengthSet = (Boolean)values[10];
        this.multiple = (Boolean)values[11];
        this.multipleSet = (Boolean)values[12];
        this.readOnly = (Boolean)values[13];
        this.readOnlySet = (Boolean)values[14];
        this.rows = (Integer)values[15];
        this.rowsSet = (Boolean)values[16];
        this.sorted = (Boolean)values[17];
        this.sortedSet = (Boolean)values[18];
        this.style = (String)values[19];
        this.styleClass = (String)values[20];
        this.tabIndex = (Integer)values[21];
        this.tabIndexSet = (Boolean)values[22];
        this.toolTip = (String)values[23];
        this.visible = (Boolean)values[24];
        this.visibleSet = (Boolean)values[25];
        this.fieldValidatorExpression = (MethodExpression)EditableList.restoreAttachedState((FacesContext)context, (Object)values[26]);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabledSet ? Boolean.TRUE : Boolean.FALSE, this.fieldLabel, this.labelLevel, this.labelLevelSet ? Boolean.TRUE : Boolean.FALSE, this.listLabel, this.listOnTop ? Boolean.TRUE : Boolean.FALSE, this.listOnTopSet ? Boolean.TRUE : Boolean.FALSE, this.maxLength, this.maxLengthSet ? Boolean.TRUE : Boolean.FALSE, this.multiple ? Boolean.TRUE : Boolean.FALSE, this.multipleSet ? Boolean.TRUE : Boolean.FALSE, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnlySet ? Boolean.TRUE : Boolean.FALSE, this.rows, this.rowsSet ? Boolean.TRUE : Boolean.FALSE, this.sorted ? Boolean.TRUE : Boolean.FALSE, this.sortedSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.tabIndex, this.tabIndexSet ? Boolean.TRUE : Boolean.FALSE, this.toolTip, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE, EditableList.saveAttachedState((FacesContext)context, (Object)this.fieldValidatorExpression)};
        return values;
    }

    private static final class RemoveListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -7559203083988359751L;

        private RemoveListener() {
        }

        public void processAction(ActionEvent event) {
            UIComponent comp = event.getComponent();
            if ((comp = comp.getParent()) instanceof EditableList) {
                ((EditableList)comp).processRemoveAction();
            }
        }
    }

    private static final class AddListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -5204715231205041623L;

        private AddListener() {
        }

        public void processAction(ActionEvent event) {
            UIComponent comp = event.getComponent();
            if ((comp = comp.getParent()) instanceof EditableList) {
                ((EditableList)comp).processAddAction();
            }
        }
    }
}

