/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.deployment.common.ClassDependencyBuilder;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parameter;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.web.loader.LogFacade;

public class ServletContainerInitializerUtil {
    private static final Logger LOG = LogFacade.getLogger();
    private static final ResourceBundle rb = LOG.getResourceBundle();

    public static ServiceLoader<ServletContainerInitializer> getServletContainerInitializers(String containerName, Map<String, String> webFragmentMap, List<Object> absoluteOrderingList, boolean hasOthers, ClassLoader jarClassLoader) {
        if (absoluteOrderingList != null && !hasOthers) {
            if (!(jarClassLoader instanceof URLClassLoader)) {
                LOG.log(Level.WARNING, "AS-WEB-UTIL-00034", jarClassLoader.getClass().getCanonicalName());
                return null;
            }
            URLClassLoader webAppCl = (URLClassLoader)jarClassLoader;
            ArrayList<URL> newClassLoaderUrlList = new ArrayList<URL>();
            for (URL classLoaderUrl : webAppCl.getURLs()) {
                String path;
                if (!"file".equals(classLoaderUrl.getProtocol())) continue;
                File file = new File(classLoaderUrl.getFile());
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!file.exists() || !(path = file.getAbsolutePath()).endsWith(".jar") || ServletContainerInitializerUtil.isFragmentMissingFromAbsoluteOrdering(file.getName(), webFragmentMap, absoluteOrderingList)) continue;
                newClassLoaderUrlList.add(classLoaderUrl);
            }
            jarClassLoader = new GlassfishUrlClassLoader("ServletContainerInitializer(" + containerName + ")", (URL[])newClassLoaderUrlList.toArray(URL[]::new), webAppCl.getParent());
        }
        return ServiceLoader.load(ServletContainerInitializer.class, jarClassLoader);
    }

    public static Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> getInterestList(Iterable<ServletContainerInitializer> initializers) {
        if (initializers == null) {
            return null;
        }
        HashMap interestList = null;
        for (ServletContainerInitializer servletContainerInitializer : initializers) {
            Class sciClass;
            HandlesTypes ann;
            if (interestList == null) {
                interestList = new HashMap();
            }
            if ((ann = (sciClass = servletContainerInitializer.getClass()).getAnnotation(HandlesTypes.class)) == null) {
                List currentInitializerList = (List)interestList.get(ServletContainerInitializerUtil.class);
                if (currentInitializerList == null) {
                    ArrayList<Class> arr = new ArrayList<Class>();
                    arr.add(sciClass);
                    interestList.put(ServletContainerInitializerUtil.class, arr);
                    continue;
                }
                currentInitializerList.add(sciClass);
                continue;
            }
            Class[] interestedClasses = ann.value();
            if (interestedClasses == null) continue;
            for (Class c : interestedClasses) {
                List currentInitializerList = (List)interestList.get(c);
                if (currentInitializerList == null) {
                    ArrayList<Class> arr = new ArrayList<Class>();
                    arr.add(sciClass);
                    interestList.put(c, arr);
                    continue;
                }
                currentInitializerList.add(sciClass);
            }
        }
        return interestList;
    }

    public static Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> getInitializerList(Iterable<ServletContainerInitializer> initializers, Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> interestList, Types types, ClassLoader cl, LogContext logContext) {
        if (interestList == null) {
            return null;
        }
        Map<Class<ServletContainerInitializer>, Set<Class<?>>> initializerList = null;
        if (interestList.containsKey(ServletContainerInitializerUtil.class)) {
            initializerList = new HashMap();
            List<Class<? extends ServletContainerInitializer>> initializersWithoutHandleTypes = interestList.get(ServletContainerInitializerUtil.class);
            for (Class<? extends ServletContainerInitializer> c : initializersWithoutHandleTypes) {
                initializerList.put(c, null);
            }
        }
        if (interestList.keySet().size() > 1 || interestList.keySet().size() == 1 && !interestList.containsKey(ServletContainerInitializerUtil.class)) {
            if (types == null || Boolean.getBoolean("org.glassfish.web.parsing")) {
                ClassDependencyBuilder classInfo = new ClassDependencyBuilder();
                if (cl instanceof URLClassLoader) {
                    URLClassLoader ucl = (URLClassLoader)cl;
                    for (URL u : ucl.getURLs()) {
                        String path = u.getPath();
                        File file = new File(path);
                        try {
                            if (path.endsWith(".jar")) {
                                try (JarFile jarFile = new JarFile(file, true, 1, Runtime.version());){
                                    Iterator entries = jarFile.versionedStream().filter(jarEntry -> !jarEntry.isDirectory() && jarEntry.getName().endsWith(".class")).iterator();
                                    while (entries.hasNext()) {
                                        JarEntry anEntry = (JarEntry)entries.next();
                                        try {
                                            InputStream jarInputStream = jarFile.getInputStream(anEntry);
                                            try {
                                                classInfo.loadClassData(jarInputStream.readAllBytes());
                                            }
                                            finally {
                                                if (jarInputStream == null) continue;
                                                jarInputStream.close();
                                            }
                                        }
                                        catch (Throwable t) {
                                            if (!LOG.isLoggable(Level.FINE)) continue;
                                            LOG.log(Level.FINE, "AS-WEB-UTIL-00035", new Object[]{anEntry.getName(), t.toString()});
                                        }
                                    }
                                    continue;
                                }
                            }
                            if (!file.exists()) continue;
                            if (file.isDirectory()) {
                                ServletContainerInitializerUtil.scanDirectory(file, classInfo);
                                continue;
                            }
                            LOG.log(Level.WARNING, "AS-WEB-UTIL-00036", path);
                        }
                        catch (IOException ioex) {
                            String msg = MessageFormat.format(rb.getString("AS-WEB-UTIL-00037"), path);
                            LOG.log(Level.SEVERE, msg, ioex);
                            return null;
                        }
                    }
                }
                initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(classInfo, interestList, initializerList, cl, logContext);
            } else {
                initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(types, interestList, initializerList, cl, logContext);
            }
        }
        for (ServletContainerInitializer initializer : initializers) {
            if (initializerList.containsKey(initializer.getClass())) continue;
            initializerList.put(initializer.getClass(), null);
        }
        return initializerList;
    }

    private static boolean isFragmentMissingFromAbsoluteOrdering(String jarName, Map<String, String> webFragmentMap, List<Object> absoluteOrderingList) {
        return webFragmentMap != null && absoluteOrderingList != null && !absoluteOrderingList.contains(webFragmentMap.get(jarName));
    }

    private static void scanDirectory(File dir, ClassDependencyBuilder classInfo) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getPath();
                if (!fileName.endsWith(".class")) continue;
                try (FileInputStream fileStream = new FileInputStream(fileName);){
                    classInfo.loadClassData(((InputStream)fileStream).readAllBytes());
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "AS-WEB-UTIL-00035", new Object[]{fileName, t.toString()});
                }
                continue;
            }
            ServletContainerInitializerUtil.scanDirectory(file, classInfo);
        }
    }

    private static Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> checkAgainstInterestList(Types classInfo, Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> initializerList, ClassLoader cl, LogContext logContext) {
        if (classInfo == null) {
            return initializerList;
        }
        for (Map.Entry<Class<?>, List<Class<ServletContainerInitializer>>> e : interestList.entrySet()) {
            Class<?> c = e.getKey();
            Type type = classInfo.getBy(c.getName());
            if (type == null) continue;
            HashSet resultSet = new HashSet();
            if (type instanceof AnnotationType) {
                for (AnnotatedElement element : ((AnnotationType)type).allAnnotatedTypes()) {
                    if (element instanceof Member) {
                        element = ((Member)element).getDeclaringType();
                    } else if (element instanceof Parameter) {
                        element = ((Parameter)element).getMethod().getDeclaringType();
                    }
                    if (!(element instanceof Type)) continue;
                    try {
                        resultSet.add(cl.loadClass(element.getName()));
                    }
                    catch (Throwable throwable) {
                        if (!LOG.isLoggable(logContext.getNonCriticalClassloadingErrorLogLevel())) continue;
                        LOG.log(logContext.getNonCriticalClassloadingErrorLogLevel(), "AS-WEB-UTIL-00035", new Object[]{element.getName(), throwable.toString()});
                    }
                }
            } else {
                Collection classes = type instanceof InterfaceModel ? ((InterfaceModel)type).allImplementations() : ((ClassModel)type).allSubTypes();
                for (ClassModel classModel : classes) {
                    try {
                        resultSet.add(cl.loadClass(classModel.getName()));
                    }
                    catch (Throwable t) {
                        if (!LOG.isLoggable(logContext.getNonCriticalClassloadingErrorLogLevel())) continue;
                        LOG.log(logContext.getNonCriticalClassloadingErrorLogLevel(), "AS-WEB-UTIL-00035", new Object[]{classModel.getName(), t.toString()});
                    }
                }
            }
            if (initializerList == null) {
                initializerList = new HashMap();
            }
            List<Class<ServletContainerInitializer>> containerInitializers = e.getValue();
            for (Class clazz : containerInitializers) {
                Set<Class<?>> classSet = initializerList.get(clazz);
                if (classSet == null) {
                    classSet = new HashSet();
                }
                classSet.addAll(resultSet);
                initializerList.put(clazz, classSet);
            }
        }
        return initializerList;
    }

    private static Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> checkAgainstInterestList(ClassDependencyBuilder classInfo, Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> initializerList, ClassLoader cl, LogContext logContext) {
        for (Map.Entry<Class<?>, List<Class<ServletContainerInitializer>>> e : interestList.entrySet()) {
            Class<?> c = e.getKey();
            Set resultFromClassInfo = classInfo.computeResult(c.getName());
            if (resultFromClassInfo.isEmpty()) continue;
            HashSet resultSet = new HashSet();
            for (String string : resultFromClassInfo) {
                String className = string.replace('/', '.');
                try {
                    Class<?> aClass = cl.loadClass(className);
                    resultSet.add(aClass);
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(logContext.getNonCriticalClassloadingErrorLogLevel())) continue;
                    LOG.log(logContext.getNonCriticalClassloadingErrorLogLevel(), "AS-WEB-UTIL-00035", new Object[]{className, t.toString()});
                }
            }
            if (initializerList == null) {
                initializerList = new HashMap();
            }
            List<Class<? extends ServletContainerInitializer>> containerInitializers = e.getValue();
            for (Class<? extends ServletContainerInitializer> initializer : containerInitializers) {
                Set<Class<?>> classSet = initializerList.get(initializer);
                if (classSet == null) {
                    classSet = new HashSet();
                }
                classSet.addAll(resultSet);
                initializerList.put(initializer, classSet);
            }
        }
        return initializerList;
    }

    public static interface LogContext {
        default public Level getNonCriticalClassloadingErrorLogLevel() {
            return Level.WARNING;
        }
    }
}

