/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.yasson.internal.serializer.BigDecimalTypeDeserializer;
import org.eclipse.yasson.internal.serializer.BigDecimalTypeSerializer;
import org.eclipse.yasson.internal.serializer.BigIntegerTypeDeserializer;
import org.eclipse.yasson.internal.serializer.BigIntegerTypeSerializer;
import org.eclipse.yasson.internal.serializer.BooleanTypeDeserializer;
import org.eclipse.yasson.internal.serializer.BooleanTypeSerializer;
import org.eclipse.yasson.internal.serializer.ByteTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ByteTypeSerializer;
import org.eclipse.yasson.internal.serializer.CalendarTypeDeserializer;
import org.eclipse.yasson.internal.serializer.CalendarTypeSerializer;
import org.eclipse.yasson.internal.serializer.CharacterTypeDeserializer;
import org.eclipse.yasson.internal.serializer.CharacterTypeSerializer;
import org.eclipse.yasson.internal.serializer.DateTypeDeserializer;
import org.eclipse.yasson.internal.serializer.DateTypeSerializer;
import org.eclipse.yasson.internal.serializer.DoubleTypeDeserializer;
import org.eclipse.yasson.internal.serializer.DoubleTypeSerializer;
import org.eclipse.yasson.internal.serializer.DurationTypeDeserializer;
import org.eclipse.yasson.internal.serializer.DurationTypeSerializer;
import org.eclipse.yasson.internal.serializer.EnumTypeDeserializer;
import org.eclipse.yasson.internal.serializer.EnumTypeSerializer;
import org.eclipse.yasson.internal.serializer.FloatTypeDeserializer;
import org.eclipse.yasson.internal.serializer.FloatTypeSerializer;
import org.eclipse.yasson.internal.serializer.InstantTypeDeserializer;
import org.eclipse.yasson.internal.serializer.InstantTypeSerializer;
import org.eclipse.yasson.internal.serializer.IntegerTypeDeserializer;
import org.eclipse.yasson.internal.serializer.IntegerTypeSerializer;
import org.eclipse.yasson.internal.serializer.JsonNumberTypeDeserializer;
import org.eclipse.yasson.internal.serializer.JsonStringTypeDeserializer;
import org.eclipse.yasson.internal.serializer.JsonValueDeserializer;
import org.eclipse.yasson.internal.serializer.JsonValueSerializer;
import org.eclipse.yasson.internal.serializer.LocalDateTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LocalDateTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.LocalDateTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LocalDateTypeSerializer;
import org.eclipse.yasson.internal.serializer.LocalTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LocalTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.LongTypeDeserializer;
import org.eclipse.yasson.internal.serializer.LongTypeSerializer;
import org.eclipse.yasson.internal.serializer.MonthDayTypeDeserializer;
import org.eclipse.yasson.internal.serializer.MonthDayTypeSerializer;
import org.eclipse.yasson.internal.serializer.NumberTypeDeserializer;
import org.eclipse.yasson.internal.serializer.NumberTypeSerializer;
import org.eclipse.yasson.internal.serializer.OffsetDateTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OffsetDateTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.OffsetTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OffsetTimeTypeSerializer;
import org.eclipse.yasson.internal.serializer.OptionalDoubleTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OptionalDoubleTypeSerializer;
import org.eclipse.yasson.internal.serializer.OptionalIntTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OptionalIntTypeSerializer;
import org.eclipse.yasson.internal.serializer.OptionalLongTypeDeserializer;
import org.eclipse.yasson.internal.serializer.OptionalLongTypeSerializer;
import org.eclipse.yasson.internal.serializer.PathTypeDeserializer;
import org.eclipse.yasson.internal.serializer.PathTypeSerializer;
import org.eclipse.yasson.internal.serializer.PeriodTypeDeserializer;
import org.eclipse.yasson.internal.serializer.PeriodTypeSerializer;
import org.eclipse.yasson.internal.serializer.SerializerProviderWrapper;
import org.eclipse.yasson.internal.serializer.ShortTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ShortTypeSerializer;
import org.eclipse.yasson.internal.serializer.SqlDateTypeDeserializer;
import org.eclipse.yasson.internal.serializer.SqlDateTypeSerializer;
import org.eclipse.yasson.internal.serializer.SqlTimestampTypeDeserializer;
import org.eclipse.yasson.internal.serializer.SqlTimestampTypeSerializer;
import org.eclipse.yasson.internal.serializer.StringTypeDeserializer;
import org.eclipse.yasson.internal.serializer.StringTypeSerializer;
import org.eclipse.yasson.internal.serializer.TimeZoneTypeDeserializer;
import org.eclipse.yasson.internal.serializer.TimeZoneTypeSerializer;
import org.eclipse.yasson.internal.serializer.URITypeDeserializer;
import org.eclipse.yasson.internal.serializer.URITypeSerializer;
import org.eclipse.yasson.internal.serializer.URLTypeDeserializer;
import org.eclipse.yasson.internal.serializer.URLTypeSerializer;
import org.eclipse.yasson.internal.serializer.UUIDTypeDeserializer;
import org.eclipse.yasson.internal.serializer.UUIDTypeSerializer;
import org.eclipse.yasson.internal.serializer.XMLGregorianCalendarTypeDeserializer;
import org.eclipse.yasson.internal.serializer.XMLGregorianCalendarTypeSerializer;
import org.eclipse.yasson.internal.serializer.YearMonthTypeDeserializer;
import org.eclipse.yasson.internal.serializer.YearMonthTypeSerializer;
import org.eclipse.yasson.internal.serializer.ZoneIdTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ZoneIdTypeSerializer;
import org.eclipse.yasson.internal.serializer.ZoneOffsetTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ZoneOffsetTypeSerializer;
import org.eclipse.yasson.internal.serializer.ZonedDateTimeTypeDeserializer;
import org.eclipse.yasson.internal.serializer.ZonedDateTimeTypeSerializer;

public class DefaultSerializers {
    private static final Map<Class<?>, SerializerProviderWrapper> SERIALIZERS = DefaultSerializers.initSerializers();
    private static final SerializerProviderWrapper ENUM_PROVIDER = new SerializerProviderWrapper(EnumTypeSerializer::new, EnumTypeDeserializer::new);

    private DefaultSerializers() {
    }

    private static Map<Class<?>, SerializerProviderWrapper> initSerializers() {
        HashMap serializers = new HashMap();
        serializers.put(Boolean.class, new SerializerProviderWrapper(BooleanTypeSerializer::new, BooleanTypeDeserializer::new));
        serializers.put(Boolean.TYPE, new SerializerProviderWrapper(BooleanTypeSerializer::new, BooleanTypeDeserializer::new));
        serializers.put(Byte.class, new SerializerProviderWrapper(ByteTypeSerializer::new, ByteTypeDeserializer::new));
        serializers.put(Byte.TYPE, new SerializerProviderWrapper(ByteTypeSerializer::new, ByteTypeDeserializer::new));
        serializers.put(Calendar.class, new SerializerProviderWrapper(CalendarTypeSerializer::new, CalendarTypeDeserializer::new));
        serializers.put(GregorianCalendar.class, new SerializerProviderWrapper(CalendarTypeSerializer::new, CalendarTypeDeserializer::new));
        serializers.put(Character.class, new SerializerProviderWrapper(CharacterTypeSerializer::new, CharacterTypeDeserializer::new));
        serializers.put(Character.TYPE, new SerializerProviderWrapper(CharacterTypeSerializer::new, CharacterTypeDeserializer::new));
        if (DefaultSerializers.isClassAvailable("java.sql.Date")) {
            serializers.put(Date.class, new SerializerProviderWrapper(SqlDateTypeSerializer::new, DateTypeDeserializer::new));
            serializers.put(java.sql.Date.class, new SerializerProviderWrapper(SqlDateTypeSerializer::new, SqlDateTypeDeserializer::new));
            serializers.put(Timestamp.class, new SerializerProviderWrapper(SqlTimestampTypeSerializer::new, SqlTimestampTypeDeserializer::new));
        } else {
            serializers.put(Date.class, new SerializerProviderWrapper(DateTypeSerializer::new, DateTypeDeserializer::new));
        }
        serializers.put(Double.class, new SerializerProviderWrapper(DoubleTypeSerializer::new, DoubleTypeDeserializer::new));
        serializers.put(Double.TYPE, new SerializerProviderWrapper(DoubleTypeSerializer::new, DoubleTypeDeserializer::new));
        serializers.put(Float.class, new SerializerProviderWrapper(FloatTypeSerializer::new, FloatTypeDeserializer::new));
        serializers.put(Float.TYPE, new SerializerProviderWrapper(FloatTypeSerializer::new, FloatTypeDeserializer::new));
        serializers.put(Instant.class, new SerializerProviderWrapper(InstantTypeSerializer::new, InstantTypeDeserializer::new));
        serializers.put(Integer.class, new SerializerProviderWrapper(IntegerTypeSerializer::new, IntegerTypeDeserializer::new));
        serializers.put(Integer.TYPE, new SerializerProviderWrapper(IntegerTypeSerializer::new, IntegerTypeDeserializer::new));
        serializers.put(JsonNumber.class, new SerializerProviderWrapper(JsonValueSerializer::new, JsonNumberTypeDeserializer::new));
        serializers.put(JsonString.class, new SerializerProviderWrapper(JsonValueSerializer::new, JsonStringTypeDeserializer::new));
        serializers.put(JsonValue.class, new SerializerProviderWrapper(JsonValueSerializer::new, JsonValueDeserializer::new));
        serializers.put(LocalDateTime.class, new SerializerProviderWrapper(LocalDateTimeTypeSerializer::new, LocalDateTimeTypeDeserializer::new));
        serializers.put(LocalDate.class, new SerializerProviderWrapper(LocalDateTypeSerializer::new, LocalDateTypeDeserializer::new));
        serializers.put(LocalTime.class, new SerializerProviderWrapper(LocalTimeTypeSerializer::new, LocalTimeTypeDeserializer::new));
        serializers.put(Long.class, new SerializerProviderWrapper(LongTypeSerializer::new, LongTypeDeserializer::new));
        serializers.put(Long.TYPE, new SerializerProviderWrapper(LongTypeSerializer::new, LongTypeDeserializer::new));
        serializers.put(Number.class, new SerializerProviderWrapper(NumberTypeSerializer::new, NumberTypeDeserializer::new));
        serializers.put(OffsetDateTime.class, new SerializerProviderWrapper(OffsetDateTimeTypeSerializer::new, OffsetDateTimeTypeDeserializer::new));
        serializers.put(OffsetTime.class, new SerializerProviderWrapper(OffsetTimeTypeSerializer::new, OffsetTimeTypeDeserializer::new));
        serializers.put(OptionalDouble.class, new SerializerProviderWrapper(OptionalDoubleTypeSerializer::new, OptionalDoubleTypeDeserializer::new));
        serializers.put(OptionalInt.class, new SerializerProviderWrapper(OptionalIntTypeSerializer::new, OptionalIntTypeDeserializer::new));
        serializers.put(OptionalLong.class, new SerializerProviderWrapper(OptionalLongTypeSerializer::new, OptionalLongTypeDeserializer::new));
        serializers.put(Path.class, new SerializerProviderWrapper(PathTypeSerializer::new, PathTypeDeserializer::new));
        serializers.put(Short.class, new SerializerProviderWrapper(ShortTypeSerializer::new, ShortTypeDeserializer::new));
        serializers.put(Short.TYPE, new SerializerProviderWrapper(ShortTypeSerializer::new, ShortTypeDeserializer::new));
        serializers.put(String.class, new SerializerProviderWrapper(StringTypeSerializer::new, StringTypeDeserializer::new));
        serializers.put(TimeZone.class, new SerializerProviderWrapper(TimeZoneTypeSerializer::new, TimeZoneTypeDeserializer::new));
        serializers.put(URI.class, new SerializerProviderWrapper(URITypeSerializer::new, URITypeDeserializer::new));
        serializers.put(URL.class, new SerializerProviderWrapper(URLTypeSerializer::new, URLTypeDeserializer::new));
        serializers.put(UUID.class, new SerializerProviderWrapper(UUIDTypeSerializer::new, UUIDTypeDeserializer::new));
        serializers.put(ZonedDateTime.class, new SerializerProviderWrapper(ZonedDateTimeTypeSerializer::new, ZonedDateTimeTypeDeserializer::new));
        serializers.put(Duration.class, new SerializerProviderWrapper(DurationTypeSerializer::new, DurationTypeDeserializer::new));
        serializers.put(Period.class, new SerializerProviderWrapper(PeriodTypeSerializer::new, PeriodTypeDeserializer::new));
        serializers.put(ZoneId.class, new SerializerProviderWrapper(ZoneIdTypeSerializer::new, ZoneIdTypeDeserializer::new));
        serializers.put(BigInteger.class, new SerializerProviderWrapper(BigIntegerTypeSerializer::new, BigIntegerTypeDeserializer::new));
        serializers.put(BigDecimal.class, new SerializerProviderWrapper(BigDecimalTypeSerializer::new, BigDecimalTypeDeserializer::new));
        serializers.put(ZoneOffset.class, new SerializerProviderWrapper(ZoneOffsetTypeSerializer::new, ZoneOffsetTypeDeserializer::new));
        if (DefaultSerializers.isClassAvailable("javax.xml.datatype.XMLGregorianCalendar")) {
            serializers.put(XMLGregorianCalendar.class, new SerializerProviderWrapper(XMLGregorianCalendarTypeSerializer::new, XMLGregorianCalendarTypeDeserializer::new));
        }
        serializers.put(YearMonth.class, new SerializerProviderWrapper(YearMonthTypeSerializer::new, YearMonthTypeDeserializer::new));
        serializers.put(MonthDay.class, new SerializerProviderWrapper(MonthDayTypeSerializer::new, MonthDayTypeDeserializer::new));
        return serializers;
    }

    public static <T> Optional<SerializerProviderWrapper> findValueSerializerProvider(Class<T> clazz) {
        Class<T> candidate = clazz;
        do {
            SerializerProviderWrapper provider;
            if ((provider = SERIALIZERS.get(candidate)) == null) continue;
            return Optional.of(provider);
        } while ((candidate = candidate.getSuperclass()) != null);
        return DefaultSerializers.findByCondition(clazz);
    }

    private static <T> Optional<SerializerProviderWrapper> findByCondition(Class<T> clazz) {
        if (Enum.class.isAssignableFrom(clazz)) {
            return Optional.of(ENUM_PROVIDER);
        }
        if (JsonString.class.isAssignableFrom(clazz)) {
            return Optional.of(SERIALIZERS.get(JsonString.class));
        }
        if (JsonNumber.class.isAssignableFrom(clazz)) {
            return Optional.of(SERIALIZERS.get(JsonNumber.class));
        }
        if (JsonValue.class.isAssignableFrom(clazz) && !JsonObject.class.isAssignableFrom(clazz) && !JsonArray.class.isAssignableFrom(clazz)) {
            return Optional.of(SERIALIZERS.get(JsonValue.class));
        }
        return Optional.empty();
    }

    public static boolean isKnownType(Class<?> clazz) {
        boolean knownContainerValueType = Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || JsonValue.class.isAssignableFrom(clazz) || Optional.class.isAssignableFrom(clazz) || clazz.isArray();
        return knownContainerValueType || DefaultSerializers.findValueSerializerProvider(clazz).isPresent();
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }
}

