/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.el.ELUtils;
import com.sun.faces.taglib.jsf_core.MaxMinValidatorTag;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.LongRangeValidator;
import jakarta.faces.validator.Validator;
import jakarta.servlet.jsp.JspException;

public class ValidateLongRangeTag
extends MaxMinValidatorTag {
    private static final long serialVersionUID = 292617728229736800L;
    private static ValueExpression VALIDATOR_ID_EXPR = null;
    protected ValueExpression maximumExpression = null;
    protected ValueExpression minimumExpression = null;
    protected long maximum = 0L;
    protected long minimum = 0L;

    public ValidateLongRangeTag() {
        if (VALIDATOR_ID_EXPR == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            ExpressionFactory factory = FacesContext.getCurrentInstance().getApplication().getExpressionFactory();
            VALIDATOR_ID_EXPR = factory.createValueExpression(context.getELContext(), "jakarta.faces.LongRange", String.class);
        }
    }

    public void setMaximum(ValueExpression newMaximum) {
        this.maximumSet = true;
        this.maximumExpression = newMaximum;
    }

    public void setMinimum(ValueExpression newMinimum) {
        this.minimumSet = true;
        this.minimumExpression = newMinimum;
    }

    @Override
    public int doStartTag() throws JspException {
        super.setValidatorId(VALIDATOR_ID_EXPR);
        return super.doStartTag();
    }

    @Override
    protected Validator createValidator() throws JspException {
        LongRangeValidator result = (LongRangeValidator)super.createValidator();
        assert (null != result);
        this.evaluateExpressions();
        if (this.maximumSet) {
            result.setMaximum(this.maximum);
        }
        if (this.minimumSet) {
            result.setMinimum(this.minimum);
        }
        return result;
    }

    private void evaluateExpressions() {
        ELContext context = FacesContext.getCurrentInstance().getELContext();
        if (this.minimumExpression != null) {
            this.minimum = !this.minimumExpression.isLiteralText() ? ((Number)ELUtils.evaluateValueExpression(this.minimumExpression, context)).longValue() : Long.valueOf(this.minimumExpression.getExpressionString()).longValue();
        }
        if (this.maximumExpression != null) {
            this.maximum = !this.maximumExpression.isLiteralText() ? ((Number)ELUtils.evaluateValueExpression(this.maximumExpression, context)).longValue() : Long.valueOf(this.maximumExpression.getExpressionString()).longValue();
        }
    }
}

