/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.ELUtils;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELResolverInitPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -1430099294315211489L;
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private boolean postInitCompleted;
    private boolean preInitCompleted;

    @Override
    public synchronized void afterPhase(PhaseEvent event) {
        if (!this.postInitCompleted && PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(event.getFacesContext().getExternalContext());
            associate.setRequestServiced();
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("jakarta.faces.lifecycle.LifecycleFactory");
            Iterator<String> i = factory.getLifecycleIds();
            while (i.hasNext()) {
                Lifecycle lifecycle = factory.getLifecycle(i.next());
                lifecycle.removePhaseListener(this);
            }
            this.postInitCompleted = true;
        }
    }

    @Override
    public synchronized void beforePhase(PhaseEvent event) {
        if (!this.preInitCompleted) {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
            associate.setRequestServiced();
            associate.initializeELResolverChains();
            associate.installProgrammaticallyAddedResolvers();
            this.preInitCompleted = true;
        }
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected void populateFacesELResolverForJsp(FacesContext context) {
        ApplicationAssociate appAssociate = ApplicationAssociate.getInstance(context.getExternalContext());
        ELResolverInitPhaseListener.populateFacesELResolverForJsp(context.getApplication(), appAssociate);
    }

    public static void populateFacesELResolverForJsp(Application app, ApplicationAssociate appAssociate) {
        FacesCompositeELResolver compositeELResolverForJsp = appAssociate.getFacesELResolverForJsp();
        if (compositeELResolverForJsp == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.lifecycle.initphaselistener.resolvers_not_registered", new Object[]{appAssociate.getContextName()});
            }
            return;
        }
        ELUtils.buildJSPResolver(compositeELResolverForJsp, appAssociate);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.lifecycle.initphaselistener.resolvers_registered", new Object[]{appAssociate.getContextName()});
        }
    }

    public static void removeELResolverInitPhaseListener() {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("jakarta.faces.lifecycle.LifecycleFactory");
        Iterator<String> i = factory.getLifecycleIds();
        while (i.hasNext()) {
            Lifecycle lifecycle = factory.getLifecycle(i.next());
            for (PhaseListener cur : lifecycle.getPhaseListeners()) {
                if (!(cur instanceof ELResolverInitPhaseListener)) continue;
                lifecycle.removePhaseListener(cur);
            }
        }
    }
}

