/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.validator;

import com.sun.faces.ext.validator.MojarraMessageFactory;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.io.Serializable;
import java.util.Locale;

public class CreditCardValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = 3534760827770436010L;

    public void validate(FacesContext context, UIComponent component, Object obj) {
        Locale locale = context.getViewRoot().getLocale();
        if (obj == null) {
            return;
        }
        if (!(obj instanceof String)) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.creditcardValidator.NOT_STRING", new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        String input = (String)obj;
        if (!input.matches("^[0-9\\ \\-]*$")) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.creditcardValidator.INVALID_CHARS", new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        if (!this.luhnCheck(this.stripNonDigit(input))) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.creditcardValidator.INVALID_NUMBER", new Object[]{null});
            throw new ValidatorException(fmsg);
        }
    }

    private String stripNonDigit(String s) {
        return s.replaceAll(" ", "").replaceAll("-", "");
    }

    private boolean luhnCheck(String number) {
        int sum = 0;
        boolean timestwo = false;
        for (int i = number.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(number.substring(i, i + 1));
            if (timestwo && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            timestwo = !timestwo;
        }
        return sum % 10 == 0;
    }
}

