/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.MethodBinding;
import jakarta.faces.el.MethodNotFoundException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionListenerImpl
implements ActionListener {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    @Override
    public void processAction(ActionEvent event) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("processAction({0})", event.getComponent().getId()));
        }
        UIComponent source = event.getComponent();
        FacesContext context = event.getFacesContext();
        MethodBinding binding = ((ActionSource)((Object)source)).getAction();
        this.invokeNavigationHandling(context, source, binding, this.getNavigationOutcome(context, binding));
        context.renderResponse();
    }

    private String getNavigationOutcome(FacesContext context, MethodBinding binding) {
        if (binding != null) {
            try {
                Object invokeResult = binding.invoke(context, null);
                if (invokeResult != null) {
                    return invokeResult.toString();
                }
            }
            catch (MethodNotFoundException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                }
                throw new FacesException(binding.getExpressionString() + ": " + e.getMessage(), e);
            }
            catch (EvaluationException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                }
                throw new FacesException(binding.getExpressionString() + ": " + e.getMessage(), e);
            }
        }
        return null;
    }

    private void invokeNavigationHandling(FacesContext context, UIComponent source, MethodBinding binding, String outcome) {
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        String toFlowDocumentId = (String)source.getAttributes().get("to-flow-document-id");
        if (toFlowDocumentId == null) {
            navHandler.handleNavigation(context, binding != null ? binding.getExpressionString() : null, outcome);
        } else {
            navHandler.handleNavigation(context, binding != null ? binding.getExpressionString() : null, outcome, toFlowDocumentId);
        }
    }
}

