/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBundleNode<T extends RootDeploymentDescriptor>
extends DisplayableComponentNode<T>
implements BundleNode,
RootXMLNode<T> {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String SCHEMA_LOCATION_TAG = "xsi:schemaLocation";
    protected String docType;

    @Override
    public void setDocType(String docType) {
        this.docType = docType;
        this.setSpecVersion();
    }

    public static Element appendChildNS(Node parent, String elementName, String nameSpace) {
        Element child = AbstractBundleNode.getOwnerDocument(parent).createElementNS(nameSpace, elementName);
        parent.appendChild(child);
        return child;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> dispatchTable = super.getDispatchTable();
        dispatchTable.put("display-name", "setDisplayName");
        dispatchTable.put("version", "setSpecVersion");
        return dispatchTable;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if (!DOLUtils.setElementValue(element, value, this.getDescriptor())) {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, T descriptor) {
        Element bundleNode;
        if (this.getDocType() == null) {
            bundleNode = AbstractBundleNode.appendChildNS(parent, this.getXMLRootTag().getQName(), "https://jakarta.ee/xml/ns/jakartaee");
            this.addBundleNodeAttributes(bundleNode, (RootDeploymentDescriptor)descriptor);
        } else {
            bundleNode = AbstractBundleNode.appendChild(parent, this.getXMLRootTag().getQName());
        }
        AbstractBundleNode.appendTextChild((Node)bundleNode, this.topLevelTagName(), this.topLevelTagValue(descriptor));
        this.writeDisplayableComponentInfo(bundleNode, descriptor);
        return bundleNode;
    }

    protected String topLevelTagName() {
        return "module-name";
    }

    protected String topLevelTagValue(T descriptor) {
        return descriptor.getModuleDescriptor().getModuleName();
    }

    @Override
    public Collection<String> elementsAllowingEmptyValue() {
        return Collections.emptySet();
    }

    @Override
    public Collection<String> elementsPreservingWhiteSpace() {
        return Collections.emptySet();
    }

    protected void writeMessageDestinations(Node parentNode, Iterator msgDestinations) {
        if (msgDestinations == null || !msgDestinations.hasNext()) {
            return;
        }
        MessageDestinationNode subNode = new MessageDestinationNode();
        while (msgDestinations.hasNext()) {
            MessageDestinationDescriptor next = (MessageDestinationDescriptor)msgDestinations.next();
            subNode.writeDescriptor(parentNode, "message-destination", next);
        }
    }

    protected void addBundleNodeAttributes(Element bundleNode, RootDeploymentDescriptor descriptor) {
        BundleDescriptor bundleDesc;
        String schemaLocation = "http://xmlns.jcp.org/xml/ns/javaee " + this.getSchemaURL();
        bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", W3C_XML_SCHEMA_INSTANCE);
        this.addNamespaceDeclaration(bundleNode, (Descriptor)descriptor);
        bundleNode.setAttributeNS(W3C_XML_SCHEMA_INSTANCE, SCHEMA_LOCATION_TAG, schemaLocation);
        bundleNode.setAttribute("version", this.getSpecVersion());
        if (descriptor instanceof BundleDescriptor && !(descriptor instanceof Application) && !(bundleDesc = (BundleDescriptor)descriptor).isDDWithNoAnnotationAllowed()) {
            bundleNode.setAttribute("metadata-complete", "true");
        }
    }

    @Override
    public void addPrefixMapping(String prefix, String uri) {
        if (uri.equals("http://java.sun.com/xml/ns/j2ee")) {
            return;
        }
        if (uri.equals("http://xmlns.jcp.org/xml/ns/javaee")) {
            return;
        }
        if (uri.equals("https://jakarta.ee/xml/ns/jakartaee")) {
            return;
        }
        if (uri.equals(W3C_XML_SCHEMA_INSTANCE)) {
            return;
        }
        super.addPrefixMapping(prefix, uri);
    }

    protected String getSchemaURL() {
        return "https://jakarta.ee/xml/ns/jakartaee/" + this.getSystemID();
    }

    protected void setSpecVersion() {
        if (this.docType == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.docType, "//");
        while (st.hasMoreElements()) {
            String tmp = st.nextToken();
            if (!tmp.startsWith("DTD")) continue;
            StringTokenizer versionST = new StringTokenizer(tmp);
            while (versionST.hasMoreElements()) {
                String versionStr = versionST.nextToken();
                try {
                    Float.valueOf(versionStr);
                    RootDeploymentDescriptor rdd = (RootDeploymentDescriptor)this.getDescriptor();
                    rdd.setSpecVersion(versionStr);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
    }
}

