/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Generator;
import jakarta.jws.WebMethod;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;

public class ServiceInterfaceGenerator
extends Generator {
    private final Class<?> ejbClass;
    private final String packageName;
    private final String serviceIntfName;
    private final String serviceIntfSimpleName;
    private final Method[] intfMethods;

    public ServiceInterfaceGenerator(ClassLoader loader, Class<?> ejbClass) {
        super(loader);
        this.ejbClass = ejbClass;
        this.packageName = ServiceInterfaceGenerator.getPackageName(ejbClass.getName());
        this.serviceIntfSimpleName = ServiceInterfaceGenerator.getServiceIntfName(ejbClass);
        this.serviceIntfName = (String)(this.packageName == null ? "" : this.packageName + ".") + this.serviceIntfSimpleName;
        this.intfMethods = ServiceInterfaceGenerator.calculateMethods(ejbClass, this.removeRedundantMethods(ejbClass.getMethods()));
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getGeneratedClassName() {
        return this.serviceIntfName;
    }

    @Override
    public Class<?> getAnchorClass() {
        return this.ejbClass;
    }

    @Override
    public void defineClassBody() {
        Wrapper._interface((int)1, (String)this.serviceIntfSimpleName, (Type[])new Type[0]);
        for (Method intfMethod : this.intfMethods) {
            this.printMethod(intfMethod);
        }
        Wrapper._end();
    }

    private void printMethod(Method m) {
        boolean throwsRemoteException = false;
        LinkedList<Type> exceptionList = new LinkedList<Type>();
        for (Class<?> exception : m.getExceptionTypes()) {
            exceptionList.add(Type.type(exception));
            if (!exception.getName().equals(RemoteException.class.getName())) continue;
            throwsRemoteException = true;
        }
        if (!throwsRemoteException) {
            exceptionList.add(Wrapper._t((String)RemoteException.class.getName()));
        }
        Wrapper._method((int)1025, (Type)Type.type(m.getReturnType()), (String)m.getName(), exceptionList);
        int i = 0;
        for (Class<?> param : m.getParameterTypes()) {
            Wrapper._arg((Type)Type.type(param), (String)("param" + i));
            ++i;
        }
        Wrapper._end();
    }

    private static String getServiceIntfName(Class<?> ejbClass) {
        String serviceIntfSimpleName = ejbClass.getSimpleName();
        if (serviceIntfSimpleName.endsWith("EJB")) {
            return serviceIntfSimpleName.substring(0, serviceIntfSimpleName.length() - 3) + "_GeneratedSEI";
        }
        return serviceIntfSimpleName + "_GeneratedSEI";
    }

    private static Method[] calculateMethods(Class sib, Method[] initialList) {
        boolean webMethodAnnotationUsed = false;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : initialList) {
            WebMethod wm = m.getAnnotation(WebMethod.class);
            if (wm != null && !webMethodAnnotationUsed) {
                webMethodAnnotationUsed = true;
                list.clear();
            }
            if (wm != null) {
                list.add(m);
                continue;
            }
            if (webMethodAnnotationUsed || m.getDeclaringClass().equals(Object.class)) continue;
            list.add(m);
        }
        return list.toArray(new Method[list.size()]);
    }
}

