/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.impl.testng;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener2;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class ProgressLoggingTestListener
implements IInvokedMethodListener2 {
    private final Logger logger = Logger.getLogger(ProgressLoggingTestListener.class.getName());
    private final AtomicInteger testMethodInvocations = new AtomicInteger(0);
    private final AtomicInteger processedTestClasses = new AtomicInteger(0);
    private Integer totalCountOfMethods = null;
    private String lastTestClassName = null;

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
        String testClassName;
        if (!method.isTestMethod()) {
            return;
        }
        if (this.totalCountOfMethods == null) {
            this.totalCountOfMethods = context.getSuite().getAllMethods().size();
        }
        if (!(testClassName = method.getTestMethod().getTestClass().getName()).equals(this.lastTestClassName)) {
            this.processedTestClasses.incrementAndGet();
            this.lastTestClassName = testClassName;
        }
        this.logger.log(Level.INFO, "Invoke {0}.{1}: {2}/{3} Failed tests: {4} ({5})", new Object[]{method.getTestMethod().getTestClass().getRealClass().getSimpleName(), method.getTestMethod().getMethodName(), this.testMethodInvocations.incrementAndGet(), this.totalCountOfMethods, context.getFailedTests().size(), this.processedTestClasses.get()});
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
    }
}

