/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.nio.charset.Charset;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Files;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFileAssert<SELF extends AbstractFileAssert<SELF>>
extends AbstractAssert<SELF, File> {
    @VisibleForTesting
    Files files = Files.instance();
    @VisibleForTesting
    Charset charset = Charset.defaultCharset();

    public AbstractFileAssert(File actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF exists() {
        this.files.assertExists(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF doesNotExist() {
        this.files.assertDoesNotExist(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isFile() {
        this.files.assertIsFile(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isDirectory() {
        this.files.assertIsDirectory(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isAbsolute() {
        this.files.assertIsAbsolute(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF isRelative() {
        this.files.assertIsRelative(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    @Deprecated
    public SELF hasContentEqualTo(File expected) {
        return this.hasSameContentAs(expected);
    }

    public SELF hasSameContentAs(File expected) {
        this.files.assertSameContentAs(this.info, (File)this.actual, this.charset, expected, Charset.defaultCharset());
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasSameContentAs(File expected, Charset expectedCharset) {
        this.files.assertSameContentAs(this.info, (File)this.actual, this.charset, expected, expectedCharset);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasBinaryContent(byte[] expected) {
        this.files.assertHasBinaryContent(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingCharset(String charsetName) {
        Preconditions.checkArgument(Charset.isSupported(charsetName), "Charset:<'%s'> is not supported on this system", charsetName);
        return this.usingCharset(Charset.forName(charsetName));
    }

    @CheckReturnValue
    public SELF usingCharset(Charset charset) {
        this.charset = Preconditions.checkNotNull(charset, "The charset should not be null");
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasContent(String expected) {
        this.files.assertHasContent(this.info, (File)this.actual, expected, this.charset);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF canWrite() {
        this.files.assertCanWrite(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF canRead() {
        this.files.assertCanRead(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasParent(File expected) {
        this.files.assertHasParent(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasParent(String expected) {
        this.files.assertHasParent(this.info, (File)this.actual, expected != null ? new File(expected) : null);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasExtension(String expected) {
        this.files.assertHasExtension(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasName(String expected) {
        this.files.assertHasName(this.info, (File)this.actual, expected);
        return (SELF)((AbstractFileAssert)this.myself);
    }

    public SELF hasNoParent() {
        this.files.assertHasNoParent(this.info, (File)this.actual);
        return (SELF)((AbstractFileAssert)this.myself);
    }
}

