/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.groupconversion;

import jakarta.validation.groups.Default;
import jakarta.validation.metadata.ConstructorDescriptor;
import jakarta.validation.metadata.GroupConversionDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import jakarta.validation.metadata.ParameterDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import jakarta.validation.metadata.ReturnValueDescriptor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.groupconversion.ConvertA;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.groupconversion.ConvertB;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.groupconversion.ConvertC;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.groupconversion.Groups;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class GroupConversionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)GroupConversionTest.webArchiveBuilder().withTestClassPackage(GroupConversionTest.class)).withValidationXml("validation-GroupConversionTest.xml")).withResource("GroupConversionTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="b")})
    public void testGroupConversionsAppliedOnMethod() throws Exception {
        MethodDescriptor methodDescriptor = TestUtil.getMethodDescriptor(Groups.class, "convert", String.class);
        Assert.assertNotNull((Object)methodDescriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = methodDescriptor.getReturnValueDescriptor();
        Set groupConversionDescriptors = returnValueDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 2 ? 1 : 0) != 0);
        List parameterDescriptors = methodDescriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        groupConversionDescriptors = parameterDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="b")})
    public void testGroupConversionsAppliedOnConstructor() throws Exception {
        ConstructorDescriptor constructorDescriptor = TestUtil.getConstructorDescriptor(Groups.class, new Class[0]);
        Assert.assertNotNull((Object)constructorDescriptor, (String)"the specified constructor should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = constructorDescriptor.getReturnValueDescriptor();
        Set groupConversionDescriptors = returnValueDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="b")})
    public void testGroupConversionsAppliedOnField() throws Exception {
        PropertyDescriptor propertyDescriptor = TestUtil.getPropertyDescriptor(Groups.class, "foo");
        Assert.assertNotNull((Object)propertyDescriptor, (String)"the specified property should be configured in xml");
        Set groupConversionDescriptors = propertyDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-groupconversions", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="d")})
    public void testGroupConversionsAppliedOnGetter() throws Exception {
        PropertyDescriptor propertyDescriptor = TestUtil.getPropertyDescriptor(Groups.class, "snafu");
        Assert.assertNotNull((Object)propertyDescriptor, (String)"the specified property should be configured in xml");
        Set groupConversionDescriptors = propertyDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 3 ? 1 : 0) != 0);
        GroupConversionDescriptor groupConversionDescriptor = this.getGroupConversionDescriptorByFrom(groupConversionDescriptors, Default.class);
        Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ConvertA.class);
        groupConversionDescriptor = this.getGroupConversionDescriptorByFrom(groupConversionDescriptors, ConvertA.class);
        Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ConvertB.class);
        groupConversionDescriptor = this.getGroupConversionDescriptorByFrom(groupConversionDescriptors, ConvertB.class);
        Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ConvertC.class);
    }

    private GroupConversionDescriptor getGroupConversionDescriptorByFrom(Set<GroupConversionDescriptor> groupConversionDescriptors, Class<?> from) {
        Optional<GroupConversionDescriptor> groupConversionDescriptor = groupConversionDescriptors.stream().filter(gcd -> from.equals(gcd.getFrom())).findAny();
        return groupConversionDescriptor.orElseThrow(() -> new IllegalStateException(String.format("Unable to find group conversion with from %1$s in %2$s", from, groupConversionDescriptors)));
    }
}

