/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.error.ShouldBe;
import org.assertj.core.error.ShouldHave;
import org.assertj.core.error.ShouldNotBe;
import org.assertj.core.error.ShouldNotHave;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Conditions {
    private static final Conditions INSTANCE = new Conditions();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Conditions instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Conditions() {
    }

    public <T> void assertIs(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBe.shouldBe(actual, condition));
    }

    public <T> void assertIsNot(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBe.shouldNotBe(actual, condition));
    }

    public <T> void assertHas(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldHave.shouldHave(actual, condition));
    }

    public <T> void assertDoesNotHave(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotHave.shouldNotHave(actual, condition));
    }

    public void assertIsNotNull(Condition<?> condition) {
        this.assertIsNotNull(condition, "The condition to evaluate should not be null", new Object[0]);
    }

    public void assertIsNotNull(Condition<?> condition, String format, Object ... args) {
        Preconditions.checkNotNull(condition, String.format(format, args));
    }
}

