/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.containerelementlevel;

import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.CollectionHelper;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ContainerElementTypeConstraintsForReturnValueXmlMappingTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ContainerElementTypeConstraintsForReturnValueXmlMappingTest.webArchiveBuilder().withTestClass(ContainerElementTypeConstraintsForReturnValueXmlMappingTest.class)).withResource("returnvalue-canDeclareContainerElementTypeConstraints-mapping.xml")).withResource("returnvalue-canDeclareNestedContainerElementTypeConstraints-mapping.xml")).withResource("returnvalue-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml")).withResource("returnvalue-canDeclareContainerElementCascades-mapping.xml")).withResource("returnvalue-declaringContainerElementTypeConstraintOnNonGenericReturnValueCausesException-mapping.xml")).withResource("returnvalue-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnReturnValueCausesException-mapping.xml")).withResource("returnvalue-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnReturnValueCausesException-mapping.xml")).withResource("returnvalue-omittingTypeArgumentForMultiTypeArgumentTypeOnReturnValueCausesException-mapping.xml")).withResource("returnvalue-configuringSameContainerElementTwiceCausesException-mapping.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="d"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareContainerElementTypeConstraintsForReturnValueWithXmlMapping() {
        Validator validator = this.getValidator("returnvalue-canDeclareContainerElementTypeConstraints-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            fishTank.test1();
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareNestedContainerElementTypeConstraintsForReturnValueWithXmlMapping() {
        Validator validator = this.getValidator("returnvalue-canDeclareNestedContainerElementTypeConstraints-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            fishTank.test2();
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareDeeplyNestedContainerElementTypeConstraintsForReturnValueWithXmlMapping() {
        Validator validator = this.getValidator("returnvalue-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            fishTank.test3();
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="h")})
    public void canDeclareContainerElementCascadesForReturnValueWithXmlMapping() {
        Validator validator = this.getValidator("returnvalue-canDeclareContainerElementCascades-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            fishTank.test4();
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="j")
    public void declaringContainerElementTypeConstraintOnNonGenericReturnValueCausesException() {
        this.getValidator("returnvalue-declaringContainerElementTypeConstraintOnNonGenericReturnValueCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnReturnValueCausesException() {
        this.getValidator("returnvalue-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnReturnValueCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnReturnValueCausesException() {
        this.getValidator("returnvalue-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnReturnValueCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="l")
    public void omittingTypeArgumentForMultiTypeArgumentTypeOnReturnValueCausesException() {
        this.getValidator("returnvalue-omittingTypeArgumentForMultiTypeArgumentTypeOnReturnValueCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="m")
    public void configuringSameContainerElementTwiceCausesException() {
        this.getValidator("returnvalue-configuringSameContainerElementTwiceCausesException-mapping.xml");
    }

    private Validator getValidator(String mappingFile) {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile));
        return config.buildValidatorFactory().getValidator();
    }

    public static class Fish {
        public String name;
    }

    public static class FishTank
    implements IFishTank {
        @Override
        public Map<String, Integer> test1() {
            HashMap<String, Integer> fishCountByType = new HashMap<String, Integer>();
            fishCountByType.put("A", -1);
            fishCountByType.put("BB", -2);
            return fishCountByType;
        }

        @Override
        public Map<String, List<Fish>> test2() {
            HashMap<String, List<Fish>> fishOfTheMonth = new HashMap<String, List<Fish>>();
            List<Fish> january = Arrays.asList(null, new Fish());
            fishOfTheMonth.put("january", january);
            return fishOfTheMonth;
        }

        @Override
        public List<Map<String, Set<String>>> test3() {
            Set<String> bobsTags = CollectionHelper.asSet(new String[]{null});
            HashMap<String, Set<String>> januaryTags = new HashMap<String, Set<String>>();
            januaryTags.put("bob", bobsTags);
            ArrayList<Map<String, Set<String>>> tagsOfFishOfTheMonth = new ArrayList<Map<String, Set<String>>>();
            tagsOfFishOfTheMonth.add(januaryTags);
            return tagsOfFishOfTheMonth;
        }

        @Override
        public Optional<Fish> test4() {
            return Optional.of(new Fish());
        }

        @Override
        public int getSize() {
            return 0;
        }
    }

    public static interface IFishTank {
        public Map<String, Integer> test1();

        public Map<String, List<Fish>> test2();

        public List<Map<String, Set<String>>> test3();

        public Optional<Fish> test4();

        public int getSize();
    }
}

