/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition;

import jakarta.validation.Constraint;
import jakarta.validation.OverridesAttribute;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.Address;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchZipcodeListContainerConstraintValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.NotEmpty;

public class FrenchAddressListContainer
extends Address {
    @Override
    @FrenchZipcodeListContainer
    public String getZipCode() {
        return super.getZipCode();
    }

    @NotEmpty
    @Size
    @Pattern.List(value={@Pattern(regexp="....."), @Pattern(regexp="bar")})
    @Constraint(validatedBy={FrenchZipcodeListContainerConstraintValidator.class})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FrenchZipcodeListContainer {
        public String message() default "Wrong zipcode";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @OverridesAttribute.List(value={@OverridesAttribute(constraint=Size.class, name="min"), @OverridesAttribute(constraint=Size.class, name="max")})
        public int size() default 5;

        @OverridesAttribute(constraint=Size.class, name="message")
        public String sizeMessage() default "A french zip code has a length of 5";

        @OverridesAttribute(constraint=Pattern.class, name="regexp", constraintIndex=1)
        public String regex() default "\\d*";
    }
}

