/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common.ui;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public final class HandlerUtils {
    private HandlerUtils() {
    }

    public static <V> V getSelectedElement(ExecutionEvent event, Class<V> type) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return SelectionUtils.getSelectedElement(selection, type);
    }

    public static <V> List<V> getSelectedElements(ExecutionEvent event, Class<V> type) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return SelectionUtils.getSelectedElements(selection, type);
    }

    public static IWorkbenchPage getActivePage(ExecutionEvent event) {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        return window.getActivePage();
    }

    public static <E extends IEditorPart> E openEditor(ExecutionEvent event, String editorId, IEditorInput editorInput) throws PartInitException {
        try {
            IWorkbenchPage page = HandlerUtils.getActivePage(event);
            return (E)page.openEditor(editorInput, editorId);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static <V extends IViewPart> V showView(ExecutionEvent event, String viewId) throws PartInitException {
        try {
            IWorkbenchPage page = HandlerUtils.getActivePage(event);
            return (V)page.showView(viewId);
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

