/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edapt.common.EcoreUtils;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.common.ReversableMap;
import org.eclipse.emf.edapt.common.TwoWayIdentityHashMap;
import org.eclipse.emf.edapt.spi.migration.AttributeSlot;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ModelResource;
import org.eclipse.emf.edapt.spi.migration.ReferenceSlot;
import org.eclipse.emf.edapt.spi.migration.Slot;
import org.eclipse.emf.edapt.spi.migration.Type;

public class BackwardConverter {
    protected ReversableMap<Instance, EObject> mapping;

    public ResourceSet convert(Model model) {
        model.getMetamodel().refreshCaches();
        this.mapping = new TwoWayIdentityHashMap();
        this.initObjects(model);
        ResourceSet resourceSet = this.initResources(model);
        this.initProperties(model);
        return resourceSet;
    }

    protected void initObjects(Model model) {
        for (Type type : model.getTypes()) {
            this.createObjects(type);
        }
    }

    protected void createObjects(Type type) {
        EClass sourceClass = type.getEClass();
        EClass targetClass = this.resolveEClass(sourceClass);
        for (Instance element : type.getInstances()) {
            EObject eObject = EcoreUtil.create((EClass)targetClass);
            if (element.isProxy()) {
                ((InternalEObject)eObject).eSetProxyURI(element.getUri());
            }
            this.mapping.put((Object)element, (Object)eObject);
        }
    }

    protected EClass resolveEClass(EClass eClass) {
        return eClass;
    }

    protected ResourceSet initResources(Model model) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ResourceUtils.register(model.getMetamodel().getEPackages(), (EPackage.Registry)resourceSet.getPackageRegistry());
        for (ModelResource modelResource : model.getResources()) {
            Resource resource = resourceSet.createResource(modelResource.getUri());
            if (resource instanceof XMLResource) {
                XMLResource xmlResource = (XMLResource)resource;
                if (modelResource.getEncoding() != null) {
                    xmlResource.setEncoding(modelResource.getEncoding());
                }
            }
            for (Instance element : modelResource.getRootInstances()) {
                resource.getContents().add((Object)this.resolve(element));
            }
        }
        return resourceSet;
    }

    protected void initProperties(Model model) {
        for (Type type : model.getTypes()) {
            for (Instance instance : type.getInstances()) {
                this.initProperties(instance);
                String uuid = instance.getUuid();
                if (uuid == null) continue;
                EObject eObject = this.resolve(instance);
                EcoreUtils.setUUID((EObject)eObject, (String)uuid);
            }
        }
    }

    protected void initProperties(Instance element) {
        EObject eObject = this.resolve(element);
        for (Slot slot : element.getSlots()) {
            EList values;
            EStructuralFeature sourceFeature = slot.getEFeature();
            EStructuralFeature targetFeature = this.resolveFeature(sourceFeature);
            if (this.ignore(sourceFeature)) continue;
            if (slot instanceof AttributeSlot) {
                if (sourceFeature.getEType() instanceof EEnum) {
                    AttributeSlot attributeSlot = (AttributeSlot)slot;
                    if (sourceFeature.isMany()) {
                        values = (EList)eObject.eGet(targetFeature);
                        for (Object value : attributeSlot.getValues()) {
                            values.add((Object)this.resolveLiteral((EEnumLiteral)value));
                        }
                        continue;
                    }
                    if (attributeSlot.getValues().isEmpty()) continue;
                    eObject.eSet(targetFeature, (Object)this.resolveLiteral((EEnumLiteral)attributeSlot.getValues().get(0)));
                    continue;
                }
                eObject.eSet(targetFeature, element.get(sourceFeature));
                continue;
            }
            ReferenceSlot referenceSlot = (ReferenceSlot)slot;
            if (sourceFeature.isMany()) {
                values = (EList)eObject.eGet(targetFeature);
                int index = 0;
                for (Instance value : referenceSlot.getValues()) {
                    EObject valueEObject = this.resolve(value);
                    if (sourceFeature.isUnique() && values.contains((Object)valueEObject)) {
                        values.move(index, (Object)valueEObject);
                    } else {
                        values.add(index, (Object)valueEObject);
                    }
                    ++index;
                }
                continue;
            }
            if (referenceSlot.getValues().isEmpty()) continue;
            eObject.eSet(targetFeature, (Object)this.resolve((Instance)referenceSlot.getValues().get(0)));
        }
    }

    protected EStructuralFeature resolveFeature(EStructuralFeature feature) {
        return feature;
    }

    protected Enumerator resolveLiteral(EEnumLiteral literal) {
        return literal;
    }

    protected boolean ignore(EStructuralFeature feature) {
        return feature.isTransient() || !feature.isChangeable() || EcorePackage.eINSTANCE.getEClass_ESuperTypes().equals(feature) || EcorePackage.eINSTANCE.getETypedElement_EType().equals(feature) || EcorePackage.eINSTANCE.getEOperation_EExceptions().equals(feature);
    }

    protected EObject resolve(Instance instance) {
        return (EObject)this.mapping.get((Object)instance);
    }
}

