/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class LoggingUtils {
    private LoggingUtils() {
    }

    public static void logInfo(Plugin plugin, String message) {
        LoggingUtils.log(plugin, 1, 0, message, null);
    }

    public static void logError(Plugin plugin, Throwable exception) {
        LoggingUtils.logError(plugin, exception.getMessage(), exception);
    }

    public static void logError(Plugin plugin, String message, Throwable exception) {
        LoggingUtils.log(plugin, 4, 0, message, exception);
    }

    public static void logError(Plugin plugin, String message) {
        LoggingUtils.logError(plugin, message, null);
    }

    public static void log(Plugin plugin, int severity, int code, String message, Throwable exception) {
        LoggingUtils.log(plugin, LoggingUtils.createStatus(plugin, severity, code, message, exception));
    }

    public static void log(Plugin plugin, IStatus status) {
        if (plugin == null) {
            return;
        }
        plugin.getLog().log(status);
    }

    public static IStatus createStatus(Plugin plugin, int severity, int code, String message, Throwable exception) {
        if (plugin == null) {
            return null;
        }
        String pluginId = plugin.getBundle().getSymbolicName();
        return new Status(severity, pluginId, code, message, exception);
    }
}

