/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="partitionComposite", label="Introduce Composite Pattern", description="In the metamodel, the composite design pattern is introduced. More specifically, a class is refined by two sub classes - one for composite and one for leaf elements, and a reference is moved to the composite class. In addition, the class is made abstract. In the model, instances of that class are migrated based on whether the reference is populated or not.")
public class PartitionComposite
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class which is refined")
    public EClass eClass;
    @EdaptParameter(description="The name of the composite class")
    public String compositeName;
    @EdaptParameter(description="The name of the leaf class")
    public String leafName;
    @EdaptParameter(description="The reference for composite elements")
    public EReference childReference;

    @EdaptConstraint(restricts="eClass", description="The class must not have sub classes")
    public boolean checkEClassNoSubTypes(EClass eClass, Metamodel metamodel) {
        return metamodel.getESubTypes(eClass).isEmpty();
    }

    @EdaptConstraint(restricts="childReference", description="The child reference must be a containment reference")
    public boolean checkChildReferenceContainment(EReference childReference) {
        return childReference.isContainment();
    }

    @EdaptConstraint(restricts="childReference", description="The child reference must be defined by the class")
    public boolean checkChildReferenceParentClass(EReference childReference) {
        return this.eClass.getEStructuralFeatures().contains((Object)childReference);
    }

    public void execute(Metamodel metamodel, Model model) {
        this.eClass.setAbstract(true);
        EPackage ePackage = this.eClass.getEPackage();
        EClass compositeClass = MetamodelFactory.newEClass((EPackage)ePackage, (String)this.compositeName, (EClass)this.eClass);
        compositeClass.getEStructuralFeatures().add((Object)this.childReference);
        EClass leafClass = MetamodelFactory.newEClass((EPackage)ePackage, (String)this.leafName, (EClass)this.eClass);
        for (Instance instance : model.getInstances(this.eClass)) {
            if (instance.getLinks(this.childReference).isEmpty()) {
                instance.migrate(leafClass);
                continue;
            }
            instance.migrate(compositeClass);
        }
    }
}

