/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.declaration.inheritance.PushFeature;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="inlineSuperClass", label="Inline Super Class", description="In the metamodel, a super class is inlined into its sub classes. More specifically, its features are propagated to the sub classes. In the model, the values of these features have to be adapted accordingly.")
public class InlineSuperClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The super class to be inlined")
    public EClass superClass;

    @EdaptConstraint(restricts="superClass", description="The super class must be abstract")
    public boolean checkSuperClassAbstract(EClass superClass) {
        return !MetamodelUtils.isConcrete((EClass)superClass);
    }

    public void execute(Metamodel metamodel, Model model) throws MigrationException {
        for (EStructuralFeature feature : new ArrayList(this.superClass.getEStructuralFeatures())) {
            PushFeature operation = new PushFeature();
            operation.feature = feature;
            operation.checkAndExecute(metamodel, model);
        }
        EList subClasses = metamodel.getESubTypes(this.superClass);
        for (EClass subClass : subClasses) {
            subClass.getESuperTypes().remove((Object)this.superClass);
            for (EClass superSuperClass : this.superClass.getESuperTypes()) {
                if (subClass.getEAllSuperTypes().contains((Object)superSuperClass)) continue;
                subClass.getESuperTypes().add((Object)superSuperClass);
            }
        }
        metamodel.delete((EModelElement)this.superClass);
    }
}

