/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.creation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="deleteClass", label="Delete Class", description="In the metamodel, a class that is no longer used is deleted. In the model, nothing is changed.")
public class DeleteClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class to be deleted")
    public EClass eClass;

    @EdaptConstraint(restricts="eClass", description="The class must not be the target of a reference")
    public boolean checkEClass(EClass eClass, Metamodel metamodel) {
        return metamodel.getInverse((EModelElement)eClass, EcorePackage.eINSTANCE.getETypedElement_EType()).isEmpty();
    }

    @EdaptConstraint(restricts="eClass", description="The class must not have sub classes")
    public boolean checkClassNoSubTypes(EClass eClass, Metamodel metamodel) {
        return metamodel.getESubTypes(eClass).isEmpty();
    }

    @EdaptConstraint(restricts="eClass", description="The class must not have super classes")
    public boolean checkClassNoSuperTypes(EClass eClass) {
        return eClass.getESuperTypes().isEmpty();
    }

    public void execute(Metamodel metamodel, Model model) {
        metamodel.delete((EModelElement)this.eClass);
    }
}

