/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.util.HashMap;
import java.util.Map;

public class ParameterDelta {
    private final Map<String, String> fOldParameters;
    private final Map<String, String> fNewParameters;

    public ParameterDelta(Map<String, String> oldParameters, Map<String, String> newParameters) {
        this.fOldParameters = new HashMap<String, String>(oldParameters);
        this.fNewParameters = new HashMap<String, String>(newParameters);
    }

    public boolean isAffected(String parameter) {
        String oldValue = this.fOldParameters.get(parameter);
        String newValue = this.fNewParameters.get(parameter);
        return oldValue != null ? !oldValue.equals(newValue) : oldValue != newValue;
    }

    public boolean isRemoved(String parameter) {
        return this.fOldParameters.containsKey(parameter) && !this.fNewParameters.containsKey(parameter);
    }

    public boolean isAdded(String parameter) {
        return !this.fOldParameters.containsKey(parameter) && this.fNewParameters.containsKey(parameter);
    }

    public boolean isModified(String parameter) {
        return this.fOldParameters.containsKey(parameter) && this.fNewParameters.containsKey(parameter) && !this.fOldParameters.get(parameter).equals(this.fNewParameters.get(parameter));
    }

    public String getOldParameter(String parameter) {
        return this.fOldParameters.get(parameter);
    }

    public void merge(ParameterDelta delta) {
        for (String key : delta.fOldParameters.keySet()) {
            if (delta.fNewParameters.containsKey(key)) continue;
            this.fNewParameters.remove(key);
        }
        this.fNewParameters.putAll(delta.fNewParameters);
    }
}

