/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.python.ResourceProjectPathImporter;
import org.python.pydev.plugin.nature.PythonNature;

public class PyDevPathImporter
extends ResourceProjectPathImporter {
    @Override
    protected void doRegisterProject(IProject project, IScriptEngine engine) {
        try {
            PythonNature pythonNature = PythonNature.getPythonNature((IProject)project);
            if (Objects.nonNull(pythonNature)) {
                String[] paths = pythonNature.getPythonPathNature().getOnlyProjectPythonPathStr(true).split("\\|");
                String importCode = Arrays.asList(paths).stream().filter(p -> Objects.nonNull(p) && !p.isEmpty()).map(p -> String.format("sys.path.append('%s')%n", p)).collect(Collectors.joining());
                String code = String.format("import sys%n%s", importCode).replace("\\", "\\\\");
                engine.inject((Object)code, false);
            }
        }
        catch (NoClassDefFoundError | ExecutionException | CoreException throwable) {
            // empty catch block
        }
    }
}

