/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.PrintStream;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;

public class ScriptExecutionException
extends RuntimeException {
    private static final long serialVersionUID = 1887518058581732543L;
    private final String fLineSource;
    private final int fColumnNumber;
    private final ScriptStackTrace fScriptStackTrace;
    private final String fErrorName;

    protected ScriptExecutionException() {
        this.fLineSource = null;
        this.fColumnNumber = 0;
        this.fScriptStackTrace = null;
        this.fErrorName = null;
    }

    public ScriptExecutionException(String message, int columnNumber, String lineSource, String errorName, ScriptStackTrace scriptStackTrace, Throwable cause) {
        super(message, cause);
        this.fLineSource = lineSource;
        this.fColumnNumber = columnNumber;
        this.fScriptStackTrace = scriptStackTrace;
        this.fErrorName = errorName;
    }

    @Override
    public final String getMessage() {
        StringBuilder buffer = new StringBuilder();
        if (this.fErrorName != null) {
            buffer.append(this.fErrorName);
            buffer.append(": ");
        }
        buffer.append(super.getMessage());
        if (this.fLineSource != null) {
            buffer.append('\n').append(this.fLineSource);
            if (this.fColumnNumber != 0) {
                buffer.append('\n');
                int i = 1;
                while (i < this.fColumnNumber) {
                    buffer.append(" ");
                    ++i;
                }
                buffer.append('^');
            }
        }
        return buffer.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        Throwable cause;
        s.println(this);
        if (this.fScriptStackTrace != null) {
            for (IScriptDebugFrame traceElement : this.fScriptStackTrace) {
                String source = traceElement.getName() != null ? traceElement.getName() : "unknown script";
                String lineInfo = traceElement.getLineNumber() > 0 ? ":" + traceElement.getLineNumber() : "";
                s.println("\tat " + source + lineInfo);
            }
        }
        if ((cause = this.getCause()) != null) {
            s.println("\nJava Stacktrace:");
            cause.printStackTrace(s);
        }
    }
}

