/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.IHeaderParser;
import org.eclipse.ease.Logger;

public abstract class AbstractHeaderParser
implements IHeaderParser {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\s*([\\p{Alnum}-_]*)\\s*:(.*)");

    @Override
    public Map<String, String> parser(InputStream stream) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String comment = this.getComment(stream);
        String key = null;
        String[] stringArray = comment.split("\\r?\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = PARAMETER_PATTERN.matcher(line);
            if (matcher.matches()) {
                key = matcher.group(1);
                parameters.put(key, matcher.group(2).trim());
            } else if (key != null && !line.trim().isEmpty() && !Pattern.matches("[" + (line = line.trim()).charAt(0) + "]+", line)) {
                parameters.put(key, String.valueOf((String)parameters.get(key)) + " " + line.trim());
            }
            ++n2;
        }
        return parameters;
    }

    @Override
    public String createHeader(Map<String, String> headerContent) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLineCommentToken());
        builder.append(' ');
        builder.append("********************************************************************************\n");
        for (String key : headerContent.keySet()) {
            StringBuilder lineBuilder = new StringBuilder();
            lineBuilder.append(this.getLineCommentToken()).append(" ").append(key);
            while (lineBuilder.length() < 24) {
                lineBuilder.append(' ');
            }
            lineBuilder.append(": ").append(headerContent.get(key)).append("\n");
            builder.append((CharSequence)lineBuilder);
        }
        builder.append(this.getLineCommentToken());
        builder.append(' ');
        builder.append("********************************************************************************\n");
        return builder.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String getComment(InputStream stream) {
        comment = new StringBuilder();
        reader = new BufferedReader(new InputStreamReader(stream));
        isComment = true;
        isBlock = false;
        try {
            while ((line = reader.readLine()) != null) {
                block9: {
                    block10: {
                        if ((line = line.trim()).isEmpty()) break block9;
                        if (!line.startsWith(this.getLineCommentToken())) break block10;
                        comment.append(line.substring(this.getLineCommentToken().length()).trim());
                        comment.append("\n");
                        break block9;
                    }
                    if (!this.hasBlockComment()) ** GOTO lbl-1000
                    if (line.startsWith(this.getBlockCommentStartToken())) {
                        isBlock = true;
                        line = line.substring(this.getBlockCommentStartToken().length()).trim();
                    }
                    if (isBlock) {
                        if (line.contains(this.getBlockCommentEndToken())) {
                            isBlock = false;
                            line = line.substring(0, line.indexOf(this.getBlockCommentEndToken()));
                        }
                        line = line.trim();
                        while (line.startsWith("*")) {
                            line = line.substring(1);
                        }
                        comment.append(line.trim());
                        comment.append("\n");
                    } else lbl-1000:
                    // 2 sources

                    {
                        isComment = false;
                    }
                }
                if (isComment) continue;
                break;
            }
        }
        catch (IOException e) {
            Logger.logError("Could not parse input stream header", e);
            return "";
        }
        return comment.toString();
    }

    protected abstract boolean hasBlockComment();

    protected abstract String getBlockCommentEndToken();

    protected abstract String getBlockCommentStartToken();

    protected abstract String getLineCommentToken();
}

