/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.diffmerge.ui.util.IUserPropertyOwner;
import org.eclipse.emf.diffmerge.ui.util.UserProperty;
import org.eclipse.jface.util.IPropertyChangeListener;

public class UserPropertyOwner
implements IUserPropertyOwner {
    protected final Map<UserProperty.Identifier<?>, UserProperty<?>> _userProperties = new HashMap();

    @Override
    public <T> boolean addUserProperty(UserProperty.Identifier<T> id_p, T initialValue_p) {
        boolean result = false;
        if (!this.hasUserProperty(id_p)) {
            UserProperty<T> prop = id_p.createProperty(initialValue_p);
            this._userProperties.put(id_p, prop);
            result = true;
        }
        return result;
    }

    @Override
    public boolean addUserPropertyChangeListener(UserProperty.Identifier<?> id_p, IPropertyChangeListener listener_p) {
        boolean result = false;
        UserProperty<?> prop = this.getUserProperty(id_p);
        if (prop != null) {
            prop.addPropertyChangeListener(listener_p);
            result = true;
        }
        return result;
    }

    public void dispose() {
        for (UserProperty<?> prop : this._userProperties.values()) {
            prop.dispose();
        }
        this._userProperties.clear();
    }

    @Override
    public Collection<UserProperty.Identifier<?>> getUserProperties() {
        return Collections.unmodifiableCollection(this._userProperties.keySet());
    }

    protected <T> UserProperty<T> getUserProperty(UserProperty.Identifier<T> id_p) {
        return this._userProperties.get(id_p);
    }

    @Override
    public <T> T getUserPropertyValue(UserProperty.Identifier<T> id_p) {
        T result = null;
        UserProperty<T> prop = this.getUserProperty(id_p);
        if (prop != null) {
            result = prop.getValue();
        }
        return result;
    }

    @Override
    public boolean hasUserProperty(UserProperty.Identifier<?> id_p) {
        return this.getUserProperty(id_p) != null;
    }

    @Override
    public boolean isUserPropertyFalse(UserProperty.Identifier<Boolean> id_p) {
        return this.hasUserProperty(id_p) && this.getUserPropertyValue(id_p) == false;
    }

    @Override
    public boolean isUserPropertyTrue(UserProperty.Identifier<Boolean> id_p) {
        return this.hasUserProperty(id_p) && this.getUserPropertyValue(id_p) != false;
    }

    @Override
    public boolean removeUserProperty(UserProperty.Identifier<?> id_p) {
        UserProperty<?> prop = this._userProperties.remove(id_p);
        return prop != null;
    }

    @Override
    public boolean removeUserPropertyChangeListener(UserProperty.Identifier<?> id_p, IPropertyChangeListener listener_p) {
        boolean result = false;
        UserProperty<?> prop = this.getUserProperty(id_p);
        if (prop != null) {
            prop.removePropertyChangeListener(listener_p);
            result = true;
        }
        return result;
    }

    @Override
    public void removeUserPropertyChangeListener(IPropertyChangeListener listener_p) {
        for (UserProperty<?> prop : this._userProperties.values()) {
            prop.removePropertyChangeListener(listener_p);
        }
    }

    @Override
    public <T> boolean setUserPropertyValue(UserProperty.Identifier<T> id_p, T newValue_p) {
        assert (newValue_p != null);
        boolean result = false;
        UserProperty<T> property = this.getUserProperty(id_p);
        if (property != null) {
            property.setValue(newValue_p);
            result = true;
        }
        return result;
    }

    @Override
    public boolean setUserPropertyValue(UserProperty.Identifier<Boolean> id_p, boolean newValue_p) {
        return this.setUserPropertyValue((UserProperty.Identifier)id_p, (Object)newValue_p);
    }
}

