/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class UIUtil {
    private UIUtil() {
    }

    public static Composite createComposite(Composite parent_p) {
        Composite result = new Composite(parent_p, 2048);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        return result;
    }

    public static Menu createMenuTool(ToolBar toolbar_p) {
        ToolItem menuTool = new ToolItem(toolbar_p, 8);
        menuTool.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.VIEW_MENU));
        final Menu result = new Menu((Control)toolbar_p.getShell());
        menuTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                result.setLocation(pt.x, pt.y + rect.height);
                result.setVisible(true);
            }
        });
        menuTool.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                result.dispose();
            }
        });
        return result;
    }

    public static ToolBar createToolBar(Composite parent_p) {
        ToolBar result = new ToolBar(parent_p, 131328);
        GridData data = new GridData(131072, 128, false, false);
        result.setData((Object)data);
        return result;
    }

    public static Font getBold(Font font_p) {
        FontData data = font_p.getFontData()[0];
        Font result = JFaceResources.getFontRegistry().getBold(data.getName());
        return result;
    }

    public static final Color getColor(int code_p) {
        return Display.getDefault().getSystemColor(code_p);
    }

    public static Image getEMFImage(Object element_p) {
        Image result = EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider().getImage(element_p);
        if (result == null) {
            Object rawImage;
            AdapterFactoryEditingDomain editingDomain;
            IItemLabelProvider provider;
            EditingDomain rawEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)element_p);
            if (rawEditingDomain == null) {
                rawEditingDomain = TransactionUtil.getEditingDomain((Object)element_p);
            }
            if (rawEditingDomain instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(editingDomain = (AdapterFactoryEditingDomain)rawEditingDomain).getAdapterFactory().adapt(element_p, IItemLabelProvider.class)) != null && (rawImage = provider.getImage(element_p)) != null) {
                result = ExtendedImageRegistry.getInstance().getImage(rawImage);
            }
        }
        return result;
    }

    public static String getEMFText(Object element_p) {
        String result = EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider().getText(element_p);
        if (result == null) {
            AdapterFactoryEditingDomain editingDomain;
            IItemLabelProvider provider;
            EditingDomain rawEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)element_p);
            if (rawEditingDomain == null) {
                rawEditingDomain = TransactionUtil.getEditingDomain((Object)element_p);
            }
            if (rawEditingDomain instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(editingDomain = (AdapterFactoryEditingDomain)rawEditingDomain).getAdapterFactory().adapt(element_p, IItemLabelProvider.class)) != null) {
                result = provider.getText(element_p);
            }
        }
        return result;
    }

    public static String getFormattedFeatureText(EStructuralFeature feature_p) {
        return FormattedTextProvider.getInstance().getFeatureText(feature_p);
    }

    public static String getFormattedTypeText(EObject element_p) {
        return FormattedTextProvider.getInstance().getTypeText(element_p);
    }

    public static Font getItalic(Font font_p) {
        FontData data = font_p.getFontData()[0];
        Font result = JFaceResources.getFontRegistry().getItalic(data.getName());
        return result;
    }

    public static void itemAddDisposeListener(Item item_p, DisposeListener listener_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        if (item_p instanceof ToolItem) {
            ((ToolItem)item_p).addDisposeListener(listener_p);
        } else {
            ((MenuItem)item_p).addDisposeListener(listener_p);
        }
    }

    public static void itemAddSelectionListener(Item item_p, SelectionListener listener_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        if (item_p instanceof ToolItem) {
            ((ToolItem)item_p).addSelectionListener(listener_p);
        } else {
            ((MenuItem)item_p).addSelectionListener(listener_p);
        }
    }

    public static Item itemCreate(Widget context_p, int style_p, Integer index_p) {
        ToolItem result;
        assert (context_p instanceof ToolBar || context_p instanceof Menu);
        if (context_p instanceof ToolBar) {
            ToolBar parent = (ToolBar)context_p;
            result = index_p == null ? new ToolItem(parent, style_p) : new ToolItem(parent, style_p, index_p.intValue());
        } else {
            Menu parent = (Menu)context_p;
            result = index_p == null ? new MenuItem(parent, style_p) : new MenuItem(parent, style_p, index_p.intValue());
        }
        return result;
    }

    public static boolean itemGetSelection(Item item_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        boolean result = item_p instanceof ToolItem ? ((ToolItem)item_p).getSelection() : ((MenuItem)item_p).getSelection();
        return result;
    }

    public static void itemSetSelection(Item item_p, boolean selected_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        if (item_p instanceof ToolItem) {
            ((ToolItem)item_p).setSelection(selected_p);
        } else {
            ((MenuItem)item_p).setSelection(selected_p);
        }
    }

    public static void itemSetText(Item item_p, String text_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        if (item_p instanceof ToolItem) {
            ((ToolItem)item_p).setToolTipText(text_p);
        } else {
            ((MenuItem)item_p).setText(text_p);
        }
    }

    public static void itemSetToolTipText(Item item_p, String tooltip_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        if (item_p instanceof MenuItem) {
            ((MenuItem)item_p).setToolTipText(tooltip_p);
        }
    }

    public static String simplifyURI(URI uri_p) {
        String result = null;
        if (uri_p != null) {
            if (uri_p.isPlatform()) {
                result = uri_p.toPlatformString(true);
            } else if (uri_p.isFile()) {
                result = uri_p.toFileString();
            } else {
                String path = uri_p.path();
                if (path == null) {
                    path = uri_p.toString();
                }
                result = URI.decode((String)path);
            }
        }
        return result;
    }

    public static TreePath toTreePath(List<?> path_p) {
        return new TreePath(path_p.toArray());
    }

    public static TreePath[] toTreePaths(List<? extends List<?>> paths_p) {
        ArrayList<TreePath> result = new ArrayList<TreePath>(paths_p.size());
        for (List<?> path : paths_p) {
            result.add(UIUtil.toTreePath(path));
        }
        return result.toArray(new TreePath[result.size()]);
    }

    protected static class FormattedTextProvider
    extends ReflectiveItemProvider {
        protected static FormattedTextProvider __instance = null;

        protected FormattedTextProvider() {
            super(null);
        }

        public String getFeatureText(Object feature_p) {
            return super.getFeatureText(feature_p);
        }

        public String getTypeText(Object object_p) {
            return super.getTypeText(object_p);
        }

        public static FormattedTextProvider getInstance() {
            if (__instance == null) {
                __instance = new FormattedTextProvider();
            }
            return __instance;
        }
    }

    public static class LabelBasedComparator
    implements Comparator<Object> {
        private final ILabelProvider _labelProvider;

        public LabelBasedComparator(ILabelProvider labelProvider_p) {
            this._labelProvider = labelProvider_p;
        }

        @Override
        public int compare(Object o1_p, Object o2_p) {
            String label2;
            String label1 = this._labelProvider.getText(o1_p);
            if (label1 == null) {
                label1 = o1_p.toString();
            }
            if ((label2 = this._labelProvider.getText(o2_p)) == null) {
                label2 = o2_p.toString();
            }
            return label1.compareTo(label2);
        }
    }
}

