/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards.application;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.operations.CompoundModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicPatternApplication;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.factories.IPatternOperationFactory;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractFilteredGraphicalUpdateOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractGraphicalWrappingInstanceOperation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternApplicationSpecification;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.factories.IPatternJobFactory;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternWizard;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.application.PatternApplicationAssociationPage;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.application.PatternApplicationPresentationPage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternApplicationWizard
extends AbstractPatternWizard<TemplatePatternApplicationSpecification> {
    protected final Object _diagramToRefresh;
    protected static final int MULTI_INSTANCE_OFFSET = 10;

    public PatternApplicationWizard(List<? extends Object> sources_p, Object diagram_p) {
        super(new TemplatePatternApplicationSpecification(sources_p));
        this._diagramToRefresh = diagram_p;
    }

    @Override
    public void doAddPages() {
        this.addPage((IWizardPage)new PatternApplicationPresentationPage((TemplatePatternApplicationSpecification)this.getData()));
        this.addPage((IWizardPage)new PatternApplicationAssociationPage((TemplatePatternApplicationSpecification)this.getData(), this._diagramToRefresh));
        this.setWindowTitle(Messages.PatternApplicationWizard_Header);
    }

    @Override
    protected boolean doPerformFinish() {
        AbstractGraphicalWrappingInstanceOperation<List<? extends IPatternInstance>> mainOperation;
        Hashtable<Object, Point> elementsLocationsMap = new Hashtable<Object, Point>();
        Hashtable<Object, Object> elementsContainersMap = new Hashtable<Object, Object>();
        if (this._diagramToRefresh != null) {
            for (Object diagramElement : this._diagramUtil.getDiagramElements(this._diagramToRefresh)) {
                if (!this._genericTypeUtil.isInstanceOfDiagramElementType(diagramElement)) continue;
                elementsLocationsMap.put(diagramElement, this._diagramUtil.getLocation(diagramElement));
            }
            for (Object diagramElement : this._diagramUtil.getDiagramElements(this._diagramToRefresh)) {
                EObject container;
                if (!this._genericTypeUtil.isInstanceOfDiagramElementType(diagramElement) || !this._genericTypeUtil.isInstanceOfGraphicalContainerType((Object)(container = this._diagramUtil.getTechnicalContainerFor(diagramElement)))) continue;
                elementsContainersMap.put(diagramElement, container);
            }
        }
        boolean result = false;
        BasicPatternApplication application = ((TemplatePatternApplicationSpecification)this.getData()).getApplication();
        boolean unfold = ((TemplatePatternApplicationSpecification)this.getData()).mustUnfoldWhenDone();
        boolean display = ((TemplatePatternApplicationSpecification)this.getData()).mustDisplayWhenDone();
        AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind refreshRequest = display ? AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.INSTANCE : (unfold ? AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.DIAGRAM : AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.NONE);
        int NB = ((TemplatePatternApplicationSpecification)this.getData()).getNumberOfApplications();
        ArrayList<AbstractGraphicalWrappingInstanceOperation<List<? extends IPatternInstance>>> applyOperations = new ArrayList<AbstractGraphicalWrappingInstanceOperation<List<? extends IPatternInstance>>>(NB);
        int i = 1;
        while (i <= NB) {
            mainOperation = new AbstractGraphicalWrappingInstanceOperation<List<? extends IPatternInstance>>((IPatternApplication)application, unfold, ((TemplatePatternApplicationSpecification)this.getData()).getNamingRule(), i, ((TemplatePatternApplicationSpecification)this.getData()).getMultiplicity(), (Object)((TemplatePatternApplicationSpecification)this.getData()).getPattern(), ((TemplatePatternApplicationSpecification)this.getData()).getScopeElement());
            applyOperations.add(mainOperation);
            ++i;
        }
        if (!applyOperations.isEmpty()) {
            CompoundModelOperation applyAllOperation = new CompoundModelOperation(((IModelOperation)applyOperations.get(0)).getName(), applyOperations, null, ((IModelOperation)applyOperations.get(0)).getTargetContext(), ((IModelOperation)applyOperations.get(0)).getSourceContext());
            mainOperation = this.instantiateGraphicalWrappingInstanceOperation((IModelOperation<List<IPatternInstance>>)applyAllOperation, this._diagramToRefresh, refreshRequest);
            List<? extends IPatternInstance> instances = this.execute(mainOperation);
            result = instances != null && !instances.isEmpty();
            ISemanticRuleProvider ruleProvider = null;
            ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(this._diagramToRefresh);
            if (result && ((TemplatePatternApplicationSpecification)this.getData()).mustReuseLayout() && this._diagramToRefresh != null && !ruleProvider.isAutomaticallyUpdatedDiagram(this._diagramToRefresh)) {
                ArrayList<AbstractFilteredGraphicalUpdateOperation> layoutOperations = new ArrayList<AbstractFilteredGraphicalUpdateOperation>(instances.size());
                int xOffset = 10;
                int yOffset = 10;
                int currentVx = 0;
                int currentVy = 0;
                for (IPatternInstance iPatternInstance : instances) {
                    AbstractFilteredGraphicalUpdateOperation layoutOperation = this.instantiateLayoutReuseOperation(this._diagramToRefresh, iPatternInstance, elementsLocationsMap, elementsContainersMap, currentVx, currentVy, true, true, ((TemplatePatternApplicationSpecification)this.getData()).getScopeElement());
                    layoutOperations.add(layoutOperation);
                    currentVx += 10;
                    currentVy += 10;
                }
                this.execute(new CompoundModelOperation(((AbstractFilteredGraphicalUpdateOperation)layoutOperations.get(0)).getName(), layoutOperations, null, ((AbstractFilteredGraphicalUpdateOperation)layoutOperations.get(0)).getTargetContext(), ((AbstractFilteredGraphicalUpdateOperation)layoutOperations.get(0)).getSourceContext()));
            }
        }
        return result;
    }

    @Override
    protected Job instantiatePatternImageBuilderJob(AbstractPatternWizard<TemplatePatternApplicationSpecification> wizard_p, List<Object> context_p, boolean updatePattern_p) {
        IPatternJobFactory factory = PatternsUIPlugin.getDefault().getJobFactory();
        if (factory != null) {
            return factory.instantiatePatternImageBuilderJob(wizard_p, context_p, updatePattern_p);
        }
        return null;
    }

    @Override
    protected Job instantiatePatternImageBuilderJob(AbstractPatternWizard<TemplatePatternApplicationSpecification> wizard_p, String imageSpecification_p, boolean updatePattern_p) {
        IPatternJobFactory factory = PatternsUIPlugin.getDefault().getJobFactory();
        if (factory != null) {
            return factory.instantiatePatternImageBuilderJob(wizard_p, imageSpecification_p, updatePattern_p);
        }
        return null;
    }

    protected AbstractFilteredGraphicalUpdateOperation instantiateLayoutReuseOperation(Object diagram_p, IPatternInstance instance_p, Map<Object, Point> initialElementsLocationsMap_p, Map<Object, Object> elementsContainersMap_p, int vx_p, int vy_p, boolean updateLayout_p, boolean updateStyle_p, Object modelSideContext_p) {
        IPatternOperationFactory factory = PatternCoreDiagramPlugin.getDefault().getOperationFactory();
        if (factory != null) {
            return factory.instantiateLayoutReuseOperation(diagram_p, instance_p, initialElementsLocationsMap_p, elementsContainersMap_p, vx_p, vy_p, updateLayout_p, updateStyle_p, modelSideContext_p);
        }
        return null;
    }

    protected AbstractGraphicalWrappingInstanceOperation<List<? extends IPatternInstance>> instantiateGraphicalWrappingInstanceOperation(IModelOperation<List<IPatternInstance>> operation_p, Object diagram_p, AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind refreshRequest_p) {
        IPatternOperationFactory factory = PatternCoreDiagramPlugin.getDefault().getOperationFactory();
        if (factory != null) {
            return factory.instantiateGraphicalWrappingInstanceOperation(operation_p, diagram_p, refreshRequest_p, true);
        }
        return null;
    }
}

