/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.environment.AbstractGenericTypeUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.AbstractDiagramUtil;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.factories.IPatternDialogAndWizardFactory;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractContextualAction<ObjectType>
implements IObjectActionDelegate {
    private IStructuredSelection _selection;
    private Shell _shell;
    private Class<ObjectType> _applicabilityClass;
    private IWorkbenchPart _part;
    protected AbstractGenericTypeUtil _genericTypeUtil = CorePatternsPlugin.getDefault().getGenericTypeUtil();
    protected AbstractDiagramUtil _diagramUtil = PatternCoreDiagramPlugin.getDefault().getDiagramUtilityClass();
    protected IPatternDialogAndWizardFactory _dialogAndWizardFactory = PatternsUIPlugin.getDefault().getDialogAndWizardFactory();

    protected AbstractContextualAction(Class<ObjectType> applicabilityClass_p) {
        this._applicabilityClass = applicabilityClass_p;
        this._selection = null;
        this._shell = null;
    }

    protected abstract void coreRun(List<Object> var1);

    protected final <E> E executeOperation(final IModelOperation<E> operation_p) {
        Display display = this.getShell() != null ? this.getShell().getDisplay() : Display.getCurrent();
        final ArrayList wrapper = new ArrayList(1);
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                Object result = CorePatternsPlugin.getDefault().getModelEnvironment().execute(operation_p);
                wrapper.add(result);
            }
        });
        return wrapper.get(0);
    }

    protected final <U> List<U> getFilteredSelection(Class<U> acceptedType_p) {
        FOrderedSet result = new FOrderedSet();
        if (this._selection != null) {
            for (Object current : this._selection) {
                if (!acceptedType_p.isInstance(current)) continue;
                result.add(current);
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected IWorkbenchPart getPart() {
        return this._part;
    }

    protected final List<Object> getSelectedElements() {
        FOrderedSet result = new FOrderedSet();
        if (this._selection != null) {
            List<Object> orderedElements = this.sortElements(this._selection.toList());
            for (Object current : orderedElements) {
                Collection<?> allRefined = this.toActualSelection(current);
                for (Object refined : allRefined) {
                    if (!this._applicabilityClass.isInstance(refined)) continue;
                    result.add(this._applicabilityClass.cast(refined));
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    private List<Object> sortElements(List<Object> elementsToSort) {
        AbstractDiagramUtil diagramUtil = PatternCoreDiagramPlugin.getDefault().getDiagramUtilityClass();
        return diagramUtil.sortElements(elementsToSort);
    }

    protected Shell getShell() {
        return this._shell;
    }

    protected IStructuredSelection getSelection() {
        return this._selection;
    }

    protected boolean mustBeEnabled() {
        return true;
    }

    public final void run(IAction action_p) {
        boolean foundFile = false;
        if (this._selection != null) {
            Iterator it = this._selection.iterator();
            ArrayList<Object> files = new ArrayList<Object>();
            while (it.hasNext()) {
                Object current = it.next();
                if (!(current instanceof IFile)) continue;
                files.add(current);
                foundFile = true;
            }
            if (foundFile) {
                this.coreRun(files);
            }
        }
        if (!foundFile) {
            List<Object> selectedElements = this.getSelectedElements();
            this.coreRun(selectedElements);
        }
    }

    public void selectionChanged(IAction action_p, ISelection selection_p) {
        this._selection = selection_p instanceof IStructuredSelection ? (IStructuredSelection)selection_p : null;
        if (action_p != null) {
            action_p.setEnabled(this.mustBeEnabled());
        }
    }

    public void setActivePart(IAction action_p, IWorkbenchPart targetPart_p) {
        this._shell = targetPart_p.getSite().getShell();
        this._part = targetPart_p;
    }

    protected Collection<?> toActualSelection(Object selected_p) {
        return Collections.singleton(selected_p);
    }
}

