/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.operations;

import java.util.Collections;
import org.eclipse.emf.diffmerge.patterns.core.Messages;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IEvaluationStatus;
import org.eclipse.emf.diffmerge.patterns.core.operations.AbstractModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicModelUpdateSpecification;

public class InstanceOperation
extends AbstractModelOperation<IEvaluationStatus> {
    private final IPatternInstance _instance;
    private final InstanceOperationKind _kind;
    private Object _specification;

    public InstanceOperation(IPatternInstance instance_p, InstanceOperationKind kind_p, Object specification_p, Object targetContext_p, Object sourceContext_p) {
        super(Messages.InstanceOperation_Name, null, true, false, false, targetContext_p, sourceContext_p);
        this._instance = instance_p;
        this._kind = kind_p;
        this._specification = specification_p;
    }

    @Override
    protected IEvaluationStatus run() {
        IEvaluationStatus result;
        switch (this._kind) {
            case DELETE_WITH_ELEMENTS: {
                result = this._instance.delete(false);
                break;
            }
            case DELETE: {
                result = this._instance.delete(true);
                break;
            }
            case FOLD: {
                result = this._instance.fold();
                break;
            }
            case UNFOLD: {
                result = this._instance.unfold();
                break;
            }
            case UPDATE: {
                result = this._instance.update(this._specification instanceof IPattern.IModelUpdateSpecification ? (IPattern.IModelUpdateSpecification)this._specification : new BasicModelUpdateSpecification());
                break;
            }
            default: {
                result = this._instance.checkConformance(this._specification instanceof BasicModelUpdateSpecification ? ((BasicModelUpdateSpecification)this._specification).getFeaturesToIgnore() : Collections.emptyList());
            }
        }
        return result;
    }

    public static enum InstanceOperationKind {
        CHECK,
        DELETE,
        DELETE_WITH_ELEMENTS,
        FOLD,
        UNFOLD,
        UPDATE;

    }
}

