/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.views;

import java.util.List;

import org.eclipse.datatools.examples.podreader.parser.PodDataParser;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ViewContentProvider implements IStructuredContentProvider {
	
	private Object[] songs;
	
	public void inputChanged(Viewer v, Object oldInput, Object newInput) {
	}
	
	public void dispose() {
	}
	
	public Object[] getElements(Object parent) {
		Object[] res = null;
		if (parent instanceof String) {
			PodDataParser parser = new PodDataParser((String)parent);
			List songList = parser.load();
			res = new Object[songList.size()];
			songList.toArray(res);
			songs = res;
		} else {
			res = songs;
		}
		return res == null? new Object[0]:res;
	}
}
