/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.restadapter.RESTGeneratorsUtility;
import org.eclipse.comma.project.project.FixedSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.PathMappings;
import org.eclipse.comma.project.project.Segment;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProvidedPortWorkerGenerator {
    public static void generate(CommaFileSystemAccess fsa, Signature signature, PathMappings pathMappings) {
        fsa.generateFile(ProvidedPortWorkerGenerator.workerFileName(signature), ProvidedPortWorkerGenerator.workerClassContent(signature, pathMappings));
    }

    public static String workerFileName(Signature signature) {
        String _name = signature.getName();
        return String.valueOf(_name) + "Worker.java";
    }

    public static CharSequence workerClassContent(Signature signature, PathMappings pathMappings) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package org.eclipse.comma.restadapter;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import javax.ws.rs.client.WebTarget;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonElement;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonParser;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.client.Entity;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.core.Response;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _name = signature.getName();
        _builder.append(_name);
        _builder.append("Worker extends Worker{");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public ");
        String _name_1 = signature.getName();
        _builder.append(_name_1, "    ");
        _builder.append("Worker(WebTarget target, String port, String component) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("super(target, port, component);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void executeEvent(JsonObject event) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("String method = event.get(\"method\").getAsString();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Event jsonReply;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("JsonElement responseMsg;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("String path;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("JsonObject replyValue;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("JsonObject responseJson;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Response response;");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("switch(method) {");
        _builder.newLine();
        EList _commands = signature.getCommands();
        for (Command command : _commands) {
            _builder.append("        ");
            _builder.append("case \"");
            String _name_2 = command.getName();
            _builder.append(_name_2, "        ");
            _builder.append("\":");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(pathMappings, (InterfaceEvent)command);
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(pathMappings, (InterfaceEvent)command);
            _builder.newLineIfNotEmpty();
            for (Parameter pathParam : pathParameters) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("JsonObject ");
                String _name_3 = pathParam.getName();
                _builder.append(_name_3, "            ");
                _builder.append("Json = event.get(\"parameters\").getAsJsonArray().get(");
                int _indexOf = command.getParameters().indexOf((Object)pathParam);
                _builder.append((Object)_indexOf, "            ");
                _builder.append(").getAsJsonObject();");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("String ");
                String _name_4 = pathParam.getName();
                _builder.append(_name_4, "            ");
                _builder.append("PathParam = ");
                String _name_5 = pathParam.getName();
                String _plus = String.valueOf(_name_5) + "Json";
                String _convertValueFromTestApp = ProvidedPortWorkerGenerator.convertValueFromTestApp(pathParam, _plus);
                _builder.append(_convertValueFromTestApp, "            ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("        ");
            _builder.append("    ");
            ProjectUtility.RESTOperation restOperation = ProjectUtility.getEventRESTMapping((InterfaceEvent)command, pathMappings);
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            Path path = ProjectUtility.getPath(pathMappings, signature, (InterfaceEvent)command);
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = pathParameters.isEmpty();
            if (_isEmpty) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("path = \"");
                EList<Segment> _segments = path.getSegments();
                for (Segment segment : _segments) {
                    _builder.append("/");
                    String _name_6 = ((FixedSegment)segment).getName();
                    _builder.append(_name_6, "            ");
                }
                _builder.append("\";");
                _builder.newLineIfNotEmpty();
            } else {
                Object segment_12;
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("path = String.format(\"");
                EList<Segment> _segments_1 = path.getSegments();
                for (Object segment_12 : _segments_1) {
                    _builder.append("/");
                    if (segment_12 instanceof FixedSegment) {
                        String _name_7 = ((FixedSegment)segment_12).getName();
                        _builder.append(_name_7, "            ");
                        continue;
                    }
                    _builder.append("%s");
                }
                _builder.append("\"");
                segment_12 = pathParameters.iterator();
                while (segment_12.hasNext()) {
                    Parameter pathParam_1 = (Parameter)segment_12.next();
                    _builder.append(", ");
                    String _name_8 = pathParam_1.getName();
                    _builder.append(_name_8, "            ");
                    _builder.append("PathParam");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            boolean _equals = Objects.equal((Object)((Object)restOperation), (Object)((Object)ProjectUtility.RESTOperation.GET));
            if (_equals) {
                StringConcatenation _builder_1;
                boolean _greaterThan;
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("// GET operation");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("responseMsg = JsonParser.parseString(target.path(path).request().get(String.class));");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("// Dealing with result value(s)");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("jsonReply = new Event(\"Reply\", \"");
                String _name_9 = signature.getName();
                _builder.append(_name_9, "            ");
                _builder.append("\", \"");
                String _name_10 = command.getName();
                _builder.append(_name_10, "            ");
                _builder.append("\", port, component);");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("    ");
                boolean multipleResults = false;
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("    ");
                boolean isVoidType = TypeUtilities.isVoid((Type)command.getType());
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("    ");
                Functions.Function1 _function = it -> {
                    DIRECTION _direction = it.getDirection();
                    return Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                };
                Iterable outParams = IterableExtensions.filter((Iterable)command.getParameters(), (Functions.Function1)_function);
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("    ");
                StringConcatenation _xblockexpression = null;
                int _size = IterableExtensions.size((Iterable)outParams);
                boolean bl = _greaterThan = _size > 1;
                if (_greaterThan) {
                    multipleResults = true;
                }
                if (IterableExtensions.size((Iterable)outParams) == 1 && !isVoidType) {
                    multipleResults = true;
                }
                _xblockexpression = _builder_1 = new StringConcatenation();
                _builder.append((Object)_xblockexpression, "            ");
                _builder.newLineIfNotEmpty();
                if (!multipleResults) {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("// Single response");
                    _builder.newLine();
                    if (isVoidType) {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("replyValue = ");
                        Object _convertValueFromSUT = RESTGeneratorsUtility.convertValueFromSUT((EObject)((Parameter[])Conversions.unwrapArray((Object)outParams, Parameter.class))[0].getType(), "responseMsg");
                        _builder.append(_convertValueFromSUT, "            ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("replyValue = ");
                        Object _convertValueFromSUT_1 = RESTGeneratorsUtility.convertValueFromSUT((EObject)command.getType(), "responseMsg");
                        _builder.append(_convertValueFromSUT_1, "            ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("jsonReply.addParameter(replyValue);");
                    _builder.newLine();
                } else {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("// Multiple results");
                    _builder.newLine();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("responseJson = responseMsg.getAsJsonObject();");
                    _builder.newLine();
                    for (Parameter p : outParams) {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("JsonObject json");
                        String _name_11 = p.getName();
                        _builder.append(_name_11, "            ");
                        _builder.append(" = ");
                        Type _type = p.getType();
                        StringConcatenation _builder_12 = new StringConcatenation();
                        _builder_12.append("responseJson.get(\"");
                        String _name_12 = p.getName();
                        _builder_12.append(_name_12);
                        _builder_12.append("\")");
                        Object _convertValueFromSUT_2 = RESTGeneratorsUtility.convertValueFromSUT((EObject)_type, _builder_12.toString());
                        _builder.append(_convertValueFromSUT_2, "            ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("jsonReply");
                    for (Parameter p_1 : outParams) {
                        _builder.append(".addParameter(json");
                        String _name_13 = p_1.getName();
                        _builder.append(_name_13, "            ");
                        _builder.append(")");
                    }
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    if (!isVoidType) {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("replyValue = ");
                        Type _type_1 = command.getType();
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("responseJson.get(\"result\")");
                        Object _convertValueFromSUT_3 = RESTGeneratorsUtility.convertValueFromSUT((EObject)_type_1, _builder_2.toString());
                        _builder.append(_convertValueFromSUT_3, "            ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("jsonReply.addParameter(replyValue);");
                        _builder.newLine();
                    }
                }
            } else {
                boolean _not;
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("// PUT operation");
                _builder.newLine();
                boolean _isEmpty_1 = nonPathParameters.isEmpty();
                if (_isEmpty_1) {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("response = target.path(path).request().put(Entity.entity(\"\", \"application/json\"));");
                    _builder.newLine();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("jsonReply = new Event(\"Reply\", \"");
                    String _name_14 = signature.getName();
                    _builder.append(_name_14, "            ");
                    _builder.append("\", \"");
                    String _name_15 = command.getName();
                    _builder.append(_name_15, "            ");
                    _builder.append("\", port, component);");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _equals_1;
                    int _size = nonPathParameters.size();
                    boolean bl = _equals_1 = _size == 1;
                    if (_equals_1) {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("// single parameter");
                        _builder.newLine();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("JsonObject param = event.get(\"parameters\").getAsJsonArray().get(");
                        int _indexOf_1 = command.getParameters().indexOf((Object)nonPathParameters.get(0));
                        _builder.append((Object)_indexOf_1, "            ");
                        _builder.append(").getAsJsonObject();");
                        _builder.newLineIfNotEmpty();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("String paramString = ");
                        String _convertValueFromTestApp_1 = ProvidedPortWorkerGenerator.convertValueFromTestApp(nonPathParameters.get(0), "param");
                        _builder.append(_convertValueFromTestApp_1, "            ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("response = target.path(path).request().put(Entity.entity(paramString, \"application/json\"));");
                        _builder.newLine();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("jsonReply = new Event(\"Reply\", \"");
                        String _name_16 = signature.getName();
                        _builder.append(_name_16, "            ");
                        _builder.append("\", \"");
                        String _name_17 = command.getName();
                        _builder.append(_name_17, "            ");
                        _builder.append("\", port, component);");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Object param_12;
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("// multiple parameters");
                        _builder.newLine();
                        for (Parameter param : nonPathParameters) {
                            _builder.append("        ");
                            _builder.append("    ");
                            _builder.append("JsonObject ");
                            String _name_18 = param.getName();
                            _builder.append(_name_18, "            ");
                            _builder.append("Json = event.get(\"parameters\").getAsJsonArray().get(");
                            int _indexOf_2 = command.getParameters().indexOf((Object)param);
                            _builder.append((Object)_indexOf_2, "            ");
                            _builder.append(").getAsJsonObject();");
                            _builder.newLineIfNotEmpty();
                            _builder.append("        ");
                            _builder.append("    ");
                            _builder.append("String ");
                            String _name_19 = param.getName();
                            _builder.append(_name_19, "            ");
                            _builder.append("String = ");
                            String _name_20 = param.getName();
                            String _plus_1 = String.valueOf(_name_20) + "Json";
                            String _convertValueFromTestApp_2 = ProvidedPortWorkerGenerator.convertValueFromTestApp(param, _plus_1);
                            _builder.append(_convertValueFromTestApp_2, "            ");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("String paramString = String.format(\"{");
                        boolean _hasElements = false;
                        for (Object param_12 : nonPathParameters) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "            ");
                            }
                            _builder.append("\\\"");
                            String _name_21 = param_12.getName();
                            _builder.append(_name_21, "            ");
                            _builder.append("\\\":%s");
                        }
                        _builder.append("}\"");
                        param_12 = nonPathParameters.iterator();
                        while (param_12.hasNext()) {
                            Parameter param_2 = (Parameter)param_12.next();
                            _builder.append(", ");
                            String _name_22 = param_2.getName();
                            _builder.append(_name_22, "            ");
                            _builder.append("String");
                        }
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("response = target.path(path).request().put(Entity.entity(paramString, \"application/json\"));");
                        _builder.newLine();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("jsonReply = new Event(\"Reply\", \"");
                        String _name_23 = signature.getName();
                        _builder.append(_name_23, "            ");
                        _builder.append("\", \"");
                        String _name_24 = command.getName();
                        _builder.append(_name_24, "            ");
                        _builder.append("\", port, component);");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("// deal with the response if the return type is not void");
                _builder.newLine();
                boolean _isVoid = TypeUtilities.isVoid((Type)command.getType());
                boolean bl = _not = !_isVoid;
                if (_not) {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("responseMsg = JsonParser.parseString(response.readEntity(String.class));");
                    _builder.newLine();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("replyValue = ");
                    Object _convertValueFromSUT_4 = RESTGeneratorsUtility.convertValueFromSUT((EObject)command.getType(), "responseMsg");
                    _builder.append(_convertValueFromSUT_4, "            ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("jsonReply.addParameter(replyValue);");
                    _builder.newLine();
                }
            }
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("outputEvent(jsonReply.toJson());");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("break;");
            _builder.newLine();
        }
        EList _signals = signature.getSignals();
        for (Signal signal : _signals) {
            _builder.append("        ");
            _builder.append("case \"");
            String _name_25 = signal.getName();
            _builder.append(_name_25, "        ");
            _builder.append("\":");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            ArrayList<Parameter> pathParameters_1 = ProjectUtility.getPathParameters(pathMappings, (InterfaceEvent)signal);
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            List<Parameter> nonPathParameters_1 = ProjectUtility.getNonPathParameters(pathMappings, (InterfaceEvent)signal);
            _builder.newLineIfNotEmpty();
            for (Parameter pathParam_2 : pathParameters_1) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("JsonObject ");
                String _name_26 = pathParam_2.getName();
                _builder.append(_name_26, "            ");
                _builder.append("Json = event.get(\"parameters\").getAsJsonArray().get(");
                int _indexOf_3 = signal.getParameters().indexOf((Object)pathParam_2);
                _builder.append((Object)_indexOf_3, "            ");
                _builder.append(").getAsJsonObject();");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("String ");
                String _name_27 = pathParam_2.getName();
                _builder.append(_name_27, "            ");
                _builder.append("PathParam = ");
                String _name_28 = pathParam_2.getName();
                String _plus_2 = String.valueOf(_name_28) + "Json";
                String _convertValueFromTestApp_3 = ProvidedPortWorkerGenerator.convertValueFromTestApp(pathParam_2, _plus_2);
                _builder.append(_convertValueFromTestApp_3, "            ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("        ");
            _builder.append("    ");
            Path path_1 = ProjectUtility.getPath(pathMappings, signature, (InterfaceEvent)signal);
            _builder.newLineIfNotEmpty();
            boolean _isEmpty_2 = pathParameters_1.isEmpty();
            if (_isEmpty_2) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("path = \"");
                EList<Segment> _segments_2 = path_1.getSegments();
                for (Segment segment_2 : _segments_2) {
                    _builder.append("/");
                    String _name_29 = ((FixedSegment)segment_2).getName();
                    _builder.append(_name_29, "            ");
                }
                _builder.append("\";");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("path = String.format(\"");
                EList<Segment> _segments_3 = path_1.getSegments();
                for (Segment segment_3 : _segments_3) {
                    _builder.append("/");
                    if (segment_3 instanceof FixedSegment) {
                        String _name_30 = ((FixedSegment)segment_3).getName();
                        _builder.append(_name_30, "            ");
                        continue;
                    }
                    _builder.append("%s");
                }
                _builder.append("\"");
                for (Parameter pathParam_3 : pathParameters_1) {
                    _builder.append(", ");
                    String _name_31 = pathParam_3.getName();
                    _builder.append(_name_31, "            ");
                    _builder.append("PathParam");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            boolean _isEmpty_3 = nonPathParameters_1.isEmpty();
            if (_isEmpty_3) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("target.path(path).request().put(Entity.entity(\"\", \"application/json\"));");
                _builder.newLine();
            } else {
                boolean _equals_2;
                int _size_1 = nonPathParameters_1.size();
                boolean bl = _equals_2 = _size_1 == 1;
                if (_equals_2) {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("// single parameter");
                    _builder.newLine();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("JsonObject param = event.get(\"parameters\").getAsJsonArray().get(");
                    int _indexOf_4 = signal.getParameters().indexOf((Object)nonPathParameters_1.get(0));
                    _builder.append((Object)_indexOf_4, "            ");
                    _builder.append(").getAsJsonObject();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("String paramString = ");
                    String _convertValueFromTestApp_4 = ProvidedPortWorkerGenerator.convertValueFromTestApp(nonPathParameters_1.get(0), "param");
                    _builder.append(_convertValueFromTestApp_4, "            ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("target.path(path).request().put(Entity.entity(paramString, \"application/json\"));");
                    _builder.newLine();
                } else {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("// multiple parameters");
                    _builder.newLine();
                    for (Parameter param_3 : nonPathParameters_1) {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("JsonObject ");
                        String _name_32 = param_3.getName();
                        _builder.append(_name_32, "            ");
                        _builder.append("Json = event.get(\"parameters\").getAsJsonArray().get(");
                        int _indexOf_5 = signal.getParameters().indexOf((Object)param_3);
                        _builder.append((Object)_indexOf_5, "            ");
                        _builder.append(").getAsJsonObject();");
                        _builder.newLineIfNotEmpty();
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("String ");
                        String _name_33 = param_3.getName();
                        _builder.append(_name_33, "            ");
                        _builder.append("String = ");
                        String _name_34 = param_3.getName();
                        String _plus_3 = String.valueOf(_name_34) + "Json";
                        String _convertValueFromTestApp_5 = ProvidedPortWorkerGenerator.convertValueFromTestApp(param_3, _plus_3);
                        _builder.append(_convertValueFromTestApp_5, "            ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("Sring paramString = String.format(\"{");
                    boolean _hasElements_1 = false;
                    for (Parameter param_4 : nonPathParameters_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "            ");
                        }
                        _builder.append("\\\"");
                        String _name_35 = param_4.getName();
                        _builder.append(_name_35, "            ");
                        _builder.append("\\\":%s");
                    }
                    _builder.append("}\"");
                    for (Parameter param_5 : nonPathParameters_1) {
                        _builder.append(", ");
                        String _name_36 = param_5.getName();
                        _builder.append(_name_36, "            ");
                        _builder.append("String");
                    }
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("target.path(path).request().put(Entity.entity(paramString, \"application/json\"));");
                    _builder.newLine();
                }
            }
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("break;");
            _builder.newLine();
        }
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public static String convertValueFromTestApp(Parameter pathParam, String expression) {
        Type _type = pathParam.getType();
        if (_type instanceof TypeReference) {
            Type _type_1 = pathParam.getType();
            TypeDecl type = ((TypeReference)_type_1).getType();
            if (type instanceof EnumTypeDecl) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("TestAppToSUT.convertEnum(");
                _builder.append(expression);
                _builder.append(")");
                return _builder.toString();
            }
            if (type instanceof SimpleTypeDecl) {
                boolean _equals;
                boolean _tripleNotEquals;
                SimpleTypeDecl _base = ((SimpleTypeDecl)type).getBase();
                boolean bl = _tripleNotEquals = _base != null;
                if (_tripleNotEquals) {
                    type = ((SimpleTypeDecl)type).getBase();
                }
                if (_equals = type.getName().equals("int")) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("TestAppToSUT.convertInt(");
                    _builder_1.append(expression);
                    _builder_1.append(")");
                    return _builder_1.toString();
                }
                boolean _equals_1 = type.getName().equals("string");
                if (_equals_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("TestAppToSUT.convertString(");
                    _builder_2.append(expression);
                    _builder_2.append(")");
                    return _builder_2.toString();
                }
                boolean _equals_2 = type.getName().equals("real");
                if (_equals_2) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("TestAppToSUT.convertReal(");
                    _builder_3.append(expression);
                    _builder_3.append(")");
                    return _builder_3.toString();
                }
                boolean _equals_3 = type.getName().equals("bool");
                if (_equals_3) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("TestAppToSUT.convertBool(");
                    _builder_4.append(expression);
                    _builder_4.append(")");
                    return _builder_4.toString();
                }
            }
            if (type instanceof RecordTypeDecl) {
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append("TestAppToSUT.convertRecord(");
                _builder_5.append(expression);
                _builder_5.append(")");
                return _builder_5.toString();
            }
            if (type instanceof VectorTypeDecl) {
                StringConcatenation _builder_6 = new StringConcatenation();
                _builder_6.append("TestAppToSUT.convertVector(");
                _builder_6.append(expression);
                _builder_6.append(")");
                return _builder_6.toString();
            }
        } else {
            Type _type_2 = pathParam.getType();
            if (_type_2 instanceof VectorTypeConstructor) {
                StringConcatenation _builder_7 = new StringConcatenation();
                _builder_7.append("TestAppToSUT.convertVector(");
                _builder_7.append(expression);
                _builder_7.append(")");
                return _builder_7.toString();
            }
        }
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("Unsuppoted type of path parameter");
        return _builder_8.toString();
    }
}

