/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.utilities;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.CommandReplyWithVars;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.PCFragment;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.Reply;
import org.eclipse.comma.actions.utilities.ActionsUtilities;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.utilities.ClauseParserUtility;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionPackage;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.signature.utilities.InterfaceUtilities;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StateMachineUtilities {
    public static Signature getSignatureForMachine(EObject context, IScopeProvider scopeProvider) {
        boolean _not;
        List signatures = CommaUtilities.resolveProxy((EObject)context, (Iterable)scopeProvider.getScope(context, ExpressionPackage.Literals.INTERFACE_AWARE_TYPE__INTERFACE).getAllElements());
        boolean _isEmpty = signatures.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return (Signature)signatures.get(0);
        }
        return null;
    }

    public static List<Signature> getSignatures(EObject context, IScopeProvider scopeProvider) {
        return CommaUtilities.resolveProxy((EObject)context, (Iterable)scopeProvider.getScope(context, ExpressionPackage.Literals.INTERFACE_AWARE_TYPE__INTERFACE).getAllElements());
    }

    public static List<Transition> transitionsForState(State s) {
        EObject _eContainer = s.eContainer();
        return StateMachineUtilities.transitionsForState((StateMachine)_eContainer, s);
    }

    public static List<Transition> transitionsForState(StateMachine sm, State s) {
        ArrayList<Transition> _xblockexpression = null;
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        EList<InAllStatesBlock> _inAllStates = sm.getInAllStates();
        for (InAllStatesBlock allStatesBlock : _inAllStates) {
            boolean _not;
            boolean _contains = allStatesBlock.getExcludedStates().contains((Object)s);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            transitions.addAll((Collection<Transition>)allStatesBlock.getTransitions());
        }
        if (s != null) {
            transitions.addAll((Collection<Transition>)s.getTransitions());
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static List<TriggeredTransition> getTriggeredTransitions(StateMachine sm, State s) {
        return IterableExtensions.toList((Iterable)Iterables.filter(StateMachineUtilities.transitionsForState(sm, s), TriggeredTransition.class));
    }

    public static List<Transition> getNonTriggeredTransitions(StateMachine sm, State s) {
        ArrayList<Transition> _xblockexpression = null;
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition t) {
                return t instanceof NonTriggeredTransition;
            }
        };
        Iterables.addAll(transitions, (Iterable)IterableExtensions.filter(StateMachineUtilities.transitionsForState(sm, s), (Functions.Function1)_function));
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static Transition getTransitionContainer(Reply r) {
        return (Transition)EcoreUtil2.getContainerOfType((EObject)r, Transition.class);
    }

    public static Transition getTransitionContainer(Clause c) {
        return (Transition)EcoreUtil2.getContainerOfType((EObject)c, Transition.class);
    }

    public static List<InterfaceEvent> getAllTriggers(StateMachine sm) {
        ArrayList<InterfaceEvent> _xblockexpression = null;
        ArrayList<InterfaceEvent> result = new ArrayList<InterfaceEvent>();
        EList<State> _states = sm.getStates();
        for (State s : _states) {
            List<TriggeredTransition> _triggeredTransitions = StateMachineUtilities.getTriggeredTransitions(sm, s);
            for (TriggeredTransition t : _triggeredTransitions) {
                boolean _not;
                boolean _contains = result.contains(t.getTrigger());
                boolean bl = _not = !_contains;
                if (!_not) continue;
                result.add(t.getTrigger());
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static List<InterfaceEvent> getAllOpenTriggers(State s) {
        ArrayList<InterfaceEvent> _xblockexpression = null;
        final ArrayList<InterfaceEvent> result = new ArrayList<InterfaceEvent>();
        EObject _eContainer = s.eContainer();
        Consumer<TriggeredTransition> _function = new Consumer<TriggeredTransition>(){

            @Override
            public void accept(TriggeredTransition it) {
                boolean _not;
                Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter it) {
                        DIRECTION _direction = it.getDirection();
                        return _direction != DIRECTION.OUT;
                    }
                };
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)it.getTrigger().getParameters(), (Functions.Function1)_function));
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    result.add(it.getTrigger());
                }
            }
        };
        StateMachineUtilities.getTriggeredTransitions((StateMachine)_eContainer, s).forEach(_function);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static List<Notification> getAllOpenNotifications(State s) {
        ArrayList<Notification> _xblockexpression = null;
        final ArrayList<Notification> result = new ArrayList<Notification>();
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(s);
        for (Transition t : _transitionsForState) {
            Functions.Function1<EventCall, Boolean> _function = new Functions.Function1<EventCall, Boolean>(){

                public Boolean apply(EventCall it) {
                    return it.getEvent() instanceof Notification && IterableExtensions.exists((Iterable)it.getParameters(), (Functions.Function1)new Functions.Function1<Expression, Boolean>(){

                        public Boolean apply(Expression it) {
                            return it instanceof ExpressionAny;
                        }
                    });
                }
            };
            Consumer<EventCall> _function_1 = new Consumer<EventCall>(){

                @Override
                public void accept(EventCall it) {
                    InterfaceEvent _event = it.getEvent();
                    result.add((Notification)_event);
                }
            };
            IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)t, EventCall.class), (Functions.Function1)_function).forEach(_function_1);
            Functions.Function1<EventWithVars, Boolean> _function_2 = new Functions.Function1<EventWithVars, Boolean>(){

                public Boolean apply(EventWithVars it) {
                    InterfaceEvent _event = it.getEvent();
                    return _event instanceof Notification;
                }
            };
            Consumer<EventWithVars> _function_3 = new Consumer<EventWithVars>(){

                @Override
                public void accept(EventWithVars it) {
                    InterfaceEvent _event = it.getEvent();
                    result.add((Notification)_event);
                }
            };
            IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)t, EventWithVars.class), (Functions.Function1)_function_2).forEach(_function_3);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static List<Command> getAllCommandsWithOpenReply(State s) {
        ArrayList<Command> _xblockexpression = null;
        ArrayList<Command> result = new ArrayList<Command>();
        EObject _eContainer = s.eContainer();
        List<TriggeredTransition> _triggeredTransitions = StateMachineUtilities.getTriggeredTransitions((StateMachine)_eContainer, s);
        for (TriggeredTransition t : _triggeredTransitions) {
            boolean _isEmpty;
            boolean _not;
            Functions.Function1<CommandReply, Boolean> _function = new Functions.Function1<CommandReply, Boolean>(){

                public Boolean apply(CommandReply it) {
                    Functions.Function1<Expression, Boolean> _function = new Functions.Function1<Expression, Boolean>(){

                        public Boolean apply(Expression it) {
                            return it instanceof ExpressionAny;
                        }
                    };
                    return IterableExtensions.exists((Iterable)it.getParameters(), (Functions.Function1)_function);
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)EcoreUtil2.getAllContentsOfType((EObject)t, CommandReply.class), (Functions.Function1)_function);
            if (_exists) {
                InterfaceEvent _trigger = t.getTrigger();
                result.add((Command)_trigger);
            }
            boolean bl = _not = !(_isEmpty = EcoreUtil2.getAllContentsOfType((EObject)t, CommandReplyWithVars.class).isEmpty());
            if (!_not) continue;
            InterfaceEvent _trigger_1 = t.getTrigger();
            result.add((Command)_trigger_1);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static List<InterfaceEvent> getAllNotifications(StateMachine sm) {
        ArrayList<InterfaceEvent> _xblockexpression = null;
        ArrayList<InterfaceEvent> result = new ArrayList<InterfaceEvent>();
        List evCalls = EcoreUtil2.getAllContentsOfType((EObject)sm, EventCall.class);
        for (EventCall evCall : evCalls) {
            if (!(evCall.getEvent() instanceof Notification) || result.contains(evCall.getEvent())) continue;
            result.add(evCall.getEvent());
        }
        List pComposition = EcoreUtil2.getAllContentsOfType((EObject)sm, ParallelComposition.class);
        for (ParallelComposition p : pComposition) {
            List _flatten = ActionsUtilities.flatten((PCFragment)p);
            for (Action c : _flatten) {
                if (!(c instanceof EventCall) || !(((EventCall)c).getEvent() instanceof Notification) || result.contains(((EventCall)c).getEvent())) continue;
                result.add(((EventCall)c).getEvent());
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static StateMachine getStateMachineContainer(EObject o) {
        return (StateMachine)EcoreUtil2.getContainerOfType((EObject)o, StateMachine.class);
    }

    public static List<ExpressionVariable> getAllExpressionVariables(State state) {
        ArrayList<ExpressionVariable> variables = new ArrayList<ExpressionVariable>();
        variables.addAll(EcoreUtil2.getAllContentsOfType((EObject)state, ExpressionVariable.class));
        return variables;
    }

    public static List<RecordTypeDecl> getRecordTypes(EObject topLevelObject, IScopeProvider scopeProvider) {
        return CommaUtilities.resolveProxy((EObject)topLevelObject, (Iterable)scopeProvider.getScope(topLevelObject, ExpressionPackage.Literals.EXPRESSION_RECORD__TYPE).getAllElements());
    }

    public static List<TypeDecl> getGlobalTypes(EObject topLevelObject, IScopeProvider scopeProvider) {
        ArrayList<TypeDecl> _xblockexpression = null;
        List allTypes = CommaUtilities.resolveProxy((EObject)topLevelObject, (Iterable)scopeProvider.getScope(topLevelObject, TypesPackage.Literals.TYPE__TYPE).getAllElements());
        ArrayList<TypeDecl> result = new ArrayList<TypeDecl>();
        for (TypeDecl t : allTypes) {
            if (t.eContainer() instanceof Signature || TypeUtilities.isPredefinedType((TypeDecl)t)) continue;
            result.add(t);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static Map<StateMachine, List<InterfaceEvent>> getEventPartitions(AbstractBehavior behavior, Signature sig) {
        HashMap<StateMachine, List<InterfaceEvent>> _xblockexpression = null;
        HashMap<StateMachine, List<InterfaceEvent>> result = new HashMap<StateMachine, List<InterfaceEvent>>();
        List unusedEvents = InterfaceUtilities.getAllInterfaceEvents((Signature)sig);
        EList<StateMachine> _machines = behavior.getMachines();
        for (StateMachine m : _machines) {
            List<InterfaceEvent> triggersForMachine = StateMachineUtilities.getAllTriggers(m);
            unusedEvents.removeAll(triggersForMachine);
            result.put(m, triggersForMachine);
        }
        EList<StateMachine> _machines_1 = behavior.getMachines();
        for (StateMachine m_1 : _machines_1) {
            List<InterfaceEvent> notificationsForMachine = StateMachineUtilities.getAllNotifications(m_1);
            unusedEvents.removeAll(notificationsForMachine);
            result.get(m_1).addAll(notificationsForMachine);
        }
        ((List)result.get(behavior.getMachines().get(0))).addAll(unusedEvents);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static HashMap<String, ArrayList<Transition>> getPNCommandsMapForState(StateMachine sm, State s) {
        HashMap<String, ArrayList<Transition>> _xblockexpression = null;
        HashMap<String, ArrayList<Transition>> commands_map = new HashMap<String, ArrayList<Transition>>();
        ArrayList<Transition> list_of_command_transitions = null;
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(sm, s);
        for (Transition transition : _transitionsForState) {
            InterfaceEvent _trigger;
            if (!(transition instanceof TriggeredTransition) || !((_trigger = ((TriggeredTransition)transition).getTrigger()) instanceof Command)) continue;
            String transitionName = ((TriggeredTransition)transition).getTrigger().getName();
            boolean _containsKey = commands_map.containsKey(transitionName);
            if (_containsKey) {
                list_of_command_transitions = commands_map.get(transitionName);
            } else {
                ArrayList _arrayList = new ArrayList();
                list_of_command_transitions = _arrayList;
            }
            list_of_command_transitions.add(transition);
            commands_map.put(transitionName, list_of_command_transitions);
        }
        _xblockexpression = commands_map;
        return _xblockexpression;
    }

    public static HashMap<String, ArrayList<Transition>> getPNSignalsMapForState(StateMachine sm, State s) {
        HashMap<String, ArrayList<Transition>> _xblockexpression = null;
        HashMap<String, ArrayList<Transition>> signals_map = new HashMap<String, ArrayList<Transition>>();
        ArrayList<Transition> list_of_signal_transitions = null;
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(sm, s);
        for (Transition transition : _transitionsForState) {
            InterfaceEvent _trigger;
            if (!(transition instanceof TriggeredTransition) || !((_trigger = ((TriggeredTransition)transition).getTrigger()) instanceof Signal)) continue;
            String transitionName = ((TriggeredTransition)transition).getTrigger().getName();
            boolean _containsKey = signals_map.containsKey(transitionName);
            if (_containsKey) {
                list_of_signal_transitions = signals_map.get(transitionName);
            } else {
                ArrayList _arrayList = new ArrayList();
                list_of_signal_transitions = _arrayList;
            }
            list_of_signal_transitions.add(transition);
            signals_map.put(transitionName, list_of_signal_transitions);
        }
        _xblockexpression = signals_map;
        return _xblockexpression;
    }

    public static HashMap<String, ArrayList<Transition>> getPNNotificationsMapForState(StateMachine machine, State state) {
        HashMap<String, ArrayList<Transition>> _xblockexpression = null;
        HashMap<String, ArrayList<Transition>> notifications_map = new HashMap<String, ArrayList<Transition>>();
        ArrayList<Transition> list_of_notification_transitions = null;
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(machine, state);
        for (Transition transition : _transitionsForState) {
            if (!(transition instanceof NonTriggeredTransition)) continue;
            EList<Clause> _clauses = ((NonTriggeredTransition)transition).getClauses();
            for (Clause clause : _clauses) {
                boolean _tripleNotEquals;
                ActionList _actions = clause.getActions();
                boolean bl = _tripleNotEquals = _actions != null;
                if (!_tripleNotEquals) continue;
                EList _actions_1 = clause.getActions().getActions();
                for (Action action : _actions_1) {
                    if (!(action instanceof EventCall)) continue;
                    EventCall eventAction = (EventCall)action;
                    String eventActionName = eventAction.getEvent().getName();
                    boolean _containsKey = notifications_map.containsKey(eventActionName);
                    if (_containsKey) {
                        list_of_notification_transitions = notifications_map.get(eventActionName);
                    } else {
                        ArrayList _arrayList = new ArrayList();
                        list_of_notification_transitions = _arrayList;
                    }
                    list_of_notification_transitions.add(transition);
                    notifications_map.put(eventActionName, list_of_notification_transitions);
                }
            }
        }
        _xblockexpression = notifications_map;
        return _xblockexpression;
    }

    public static String constructCommandTypeName(Command c, String interface_name) {
        boolean _equals = c.getType().getType().getName().equals("void");
        if (_equals) {
            return "void";
        }
        TypeDecl _type = c.getType().getType();
        if (_type instanceof EnumTypeDecl) {
            String _name = c.getType().getType().getName();
            String _plus = String.valueOf(interface_name) + "::" + _name;
            String _plus_1 = String.valueOf(_plus) + "::";
            String _name_1 = c.getType().getType().getName();
            return String.valueOf(_plus_1) + _name_1;
        }
        TypeDecl _type_1 = c.getType().getType();
        if (_type_1 instanceof SimpleTypeDecl) {
            return c.getType().getType().getName();
        }
        String _name_2 = c.getType().getType().getName();
        return String.valueOf(interface_name) + "::" + _name_2;
    }

    public static HashMap<String, ArrayList<Transition>> getCommandsMapForState(StateMachine sm, Signature sig, State s) {
        HashMap<String, ArrayList<Transition>> _xblockexpression = null;
        HashMap<String, ArrayList<Transition>> commands_map = new HashMap<String, ArrayList<Transition>>();
        ArrayList<Transition> list_of_command_transitions = null;
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(sm, s);
        for (Transition transition : _transitionsForState) {
            InterfaceEvent _trigger;
            if (!(transition instanceof TriggeredTransition) || !((_trigger = ((TriggeredTransition)transition).getTrigger()) instanceof Command)) continue;
            String _name = sig.getName();
            String _plus = String.valueOf(_name) + "_";
            String _name_1 = ((TriggeredTransition)transition).getTrigger().getName();
            String transitionName = String.valueOf(_plus) + _name_1;
            boolean _containsKey = commands_map.containsKey(transitionName);
            if (_containsKey) {
                list_of_command_transitions = commands_map.get(transitionName);
            } else {
                ArrayList _arrayList = new ArrayList();
                list_of_command_transitions = _arrayList;
            }
            list_of_command_transitions.add(transition);
            commands_map.put(transitionName, list_of_command_transitions);
        }
        _xblockexpression = commands_map;
        return _xblockexpression;
    }

    public static HashMap<String, ArrayList<Transition>> getSignalsMapForState(StateMachine sm, Signature sig, State s) {
        HashMap<String, ArrayList<Transition>> _xblockexpression = null;
        HashMap<String, ArrayList<Transition>> signals_map = new HashMap<String, ArrayList<Transition>>();
        ArrayList<Transition> list_of_signal_transitions = null;
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(sm, s);
        for (Transition transition : _transitionsForState) {
            InterfaceEvent _trigger;
            if (!(transition instanceof TriggeredTransition) || !((_trigger = ((TriggeredTransition)transition).getTrigger()) instanceof Signal)) continue;
            String _name = sig.getName();
            String _plus = String.valueOf(_name) + "_";
            String _name_1 = ((TriggeredTransition)transition).getTrigger().getName();
            String transitionName = String.valueOf(_plus) + _name_1;
            boolean _containsKey = signals_map.containsKey(transitionName);
            if (_containsKey) {
                list_of_signal_transitions = signals_map.get(transitionName);
            } else {
                ArrayList _arrayList = new ArrayList();
                list_of_signal_transitions = _arrayList;
            }
            list_of_signal_transitions.add(transition);
            signals_map.put(transitionName, list_of_signal_transitions);
        }
        _xblockexpression = signals_map;
        return _xblockexpression;
    }

    public static boolean checkTransitionForReplies(NonTriggeredTransition nt) {
        boolean isReplyTransition = false;
        EList<Clause> _clauses = nt.getClauses();
        for (Clause cl : _clauses) {
            boolean _hasReply;
            boolean _not;
            boolean _isEmpty = EcoreUtil2.getAllContentsOfType((EObject)cl, CommandReply.class).isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not || !(_hasReply = StateMachineUtilities.hasReply(cl.getActions()))) continue;
            isReplyTransition = true;
        }
        return isReplyTransition;
    }

    public static boolean hasReply(ActionList actionList) {
        if (actionList == null) {
            return false;
        }
        EList _actions = actionList.getActions();
        for (Action action : _actions) {
            if (action instanceof CommandReply) {
                return true;
            }
            if (!(action instanceof IfAction) || !StateMachineUtilities.hasReply(((IfAction)action).getThenList()) || !StateMachineUtilities.hasReply(((IfAction)action).getElseList())) continue;
            return true;
        }
        return false;
    }

    public static InterfaceEvent getReplyToCommandName(NonTriggeredTransition nt) {
        EList<Clause> _clauses = nt.getClauses();
        for (Clause cl : _clauses) {
            boolean _tripleNotEquals;
            boolean _not;
            boolean _isEmpty = EcoreUtil2.getAllContentsOfType((EObject)cl, CommandReply.class).isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            InterfaceEvent _anyReply = StateMachineUtilities.getAnyReply(cl.getActions());
            boolean bl2 = _tripleNotEquals = _anyReply != null;
            if (!_tripleNotEquals) continue;
            return StateMachineUtilities.getAnyReply(cl.getActions());
        }
        return null;
    }

    public static InterfaceEvent getAnyReply(ActionList actionList) {
        if (actionList == null) {
            return null;
        }
        EList _actions = actionList.getActions();
        for (Action action : _actions) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            if (action instanceof CommandReply) {
                return ((CommandReply)action).getCommand().getEvent();
            }
            if (!(action instanceof IfAction)) continue;
            InterfaceEvent _anyReply = StateMachineUtilities.getAnyReply(((IfAction)action).getThenList());
            boolean bl = _tripleNotEquals = _anyReply != null;
            if (_tripleNotEquals) {
                return StateMachineUtilities.getAnyReply(((IfAction)action).getThenList());
            }
            InterfaceEvent _anyReply_1 = StateMachineUtilities.getAnyReply(((IfAction)action).getElseList());
            boolean bl2 = _tripleNotEquals_1 = _anyReply_1 != null;
            if (!_tripleNotEquals_1) continue;
            return StateMachineUtilities.getAnyReply(((IfAction)action).getThenList());
        }
        return null;
    }

    public static HashMap<String, ArrayList<Transition>> getNotificationsMapForState(StateMachine machine, Signature sig, State state) {
        HashMap<String, ArrayList<Transition>> _xblockexpression = null;
        boolean isNotificationFoundInClause = false;
        String _name = sig.getName();
        ClauseParserUtility clParserUtility = new ClauseParserUtility(_name);
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(machine, state);
        for (Transition transition : _transitionsForState) {
            boolean _not;
            if (!(transition instanceof NonTriggeredTransition)) continue;
            boolean _checkTransitionForReplies = StateMachineUtilities.checkTransitionForReplies((NonTriggeredTransition)transition);
            boolean bl = _not = !_checkTransitionForReplies;
            if (!_not) continue;
            EList<Clause> _clauses = ((NonTriggeredTransition)transition).getClauses();
            for (Clause clause : _clauses) {
                boolean _tripleNotEquals;
                isNotificationFoundInClause = false;
                ActionList _actions = clause.getActions();
                boolean bl2 = _tripleNotEquals = _actions != null;
                if (!_tripleNotEquals) continue;
                EList _actions_1 = clause.getActions().getActions();
                for (Action action : _actions_1) {
                    if (!isNotificationFoundInClause) {
                        clParserUtility.generateAllActionsForClause(action, (NonTriggeredTransition)transition);
                    }
                    if (!(action instanceof EventCall)) continue;
                    isNotificationFoundInClause = true;
                }
            }
        }
        _xblockexpression = clParserUtility.getNotificationsMap();
        return _xblockexpression;
    }

    public static HashMap<String, ArrayList<Transition>> getRepliesMapForState(StateMachine machine, Signature sig, State state) {
        HashMap<String, ArrayList<Transition>> replies_map = new HashMap<String, ArrayList<Transition>>();
        ArrayList<Transition> list_of_reply_transitions = null;
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(machine, state);
        for (Transition transition : _transitionsForState) {
            boolean _checkTransitionForReplies;
            if (!(transition instanceof NonTriggeredTransition) || !(_checkTransitionForReplies = StateMachineUtilities.checkTransitionForReplies((NonTriggeredTransition)transition))) continue;
            String _name = sig.getName();
            String _plus = String.valueOf(_name) + "_";
            String _name_1 = StateMachineUtilities.getReplyToCommandName((NonTriggeredTransition)transition).getName();
            String transitionName = String.valueOf(_plus) + _name_1;
            boolean _containsKey = replies_map.containsKey(transitionName);
            if (_containsKey) {
                list_of_reply_transitions = replies_map.get(transitionName);
            } else {
                ArrayList _arrayList = new ArrayList();
                list_of_reply_transitions = _arrayList;
            }
            list_of_reply_transitions.add(transition);
            replies_map.put(transitionName, list_of_reply_transitions);
        }
        return replies_map;
    }

    public static boolean determineIfNotificationExistsInList(String ni_name, ArrayList<String> ni_list, ArrayList<ArrayList<String>> ni_listOflist) {
        boolean _contains = ni_list.contains(ni_name);
        if (_contains) {
            return true;
        }
        for (ArrayList<String> elm_list : ni_listOflist) {
            boolean _contains_1 = elm_list.contains(ni_name);
            if (!_contains_1) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<ArrayList<String>> getAllNestedListOfNotifications(StateMachine machine, Signature sig, State state) {
        ArrayList<ArrayList<String>> _xblockexpression = null;
        ArrayList<ArrayList<String>> ni_listOflist = new ArrayList<ArrayList<String>>();
        List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(machine, state);
        for (Transition transition : _transitionsForState) {
            if (!(transition instanceof NonTriggeredTransition)) continue;
            EList<Clause> _clauses = ((NonTriggeredTransition)transition).getClauses();
            for (Clause clause : _clauses) {
                boolean _tripleNotEquals;
                ActionList _actions = clause.getActions();
                boolean bl = _tripleNotEquals = _actions != null;
                if (!_tripleNotEquals) continue;
                ArrayList<String> ni_list = new ArrayList<String>();
                EList _actions_1 = clause.getActions().getActions();
                for (Action action : _actions_1) {
                    if (!(action instanceof EventCall)) continue;
                    EventCall eventAction = (EventCall)action;
                    String _name = sig.getName();
                    String _plus = String.valueOf(_name) + "_";
                    String _name_1 = eventAction.getEvent().getName();
                    String eventActionName = String.valueOf(_plus) + _name_1;
                    ni_list.add(eventActionName);
                }
                ni_listOflist.add(ni_list);
            }
        }
        _xblockexpression = ni_listOflist;
        return _xblockexpression;
    }
}

