/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.comma.monitoring.lib.constraints.CConditionedAbsenceOfEventTimeRule;
import org.eclipse.comma.monitoring.lib.constraints.CConditionedEventTimeRule;
import org.eclipse.comma.monitoring.lib.constraints.CEventIntervalTimeRule;
import org.eclipse.comma.monitoring.lib.constraints.CRule;
import org.eclipse.comma.monitoring.lib.constraints.CRuleObserver;
import org.eclipse.comma.monitoring.lib.constraints.CSimpleTimeRule;
import org.eclipse.comma.monitoring.lib.utils.Utils;
import org.eclipse.comma.monitoring.lib.values.CInterval;

public class CTimeRuleObserver
extends CRuleObserver {
    public CTimeRuleObserver(String fileName, String ruleType) {
        super(fileName, ruleType);
    }

    private void handleEvent(CRule rule) {
        try {
            FileWriter file = this.getFile();
            String toWrite = String.valueOf(rule.getName()) + ",";
            double diff = Utils.roundDouble(rule.getLastObservation().getTimeDelta() - rule.getTriggeringObservation().getTimeDelta(), 3);
            toWrite = String.valueOf(toWrite) + diff + ",";
            CInterval i = ((CSimpleTimeRule)rule).getEnvironment().getInterval();
            toWrite = String.valueOf(toWrite) + i.getBegin() + ",";
            toWrite = String.valueOf(toWrite) + i.getEnd();
            file.write(String.valueOf(toWrite) + "\n");
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ruleFailed(CRule rule) {
        if (rule instanceof CConditionedAbsenceOfEventTimeRule || rule instanceof CConditionedEventTimeRule) {
            this.handleEvent(rule);
        }
    }

    @Override
    public void ruleSucceeded(CRule rule) {
        if (rule instanceof CConditionedEventTimeRule) {
            this.handleEvent(rule);
        }
    }

    public void intervalChecked(CSimpleTimeRule rule, double v) {
        if (!(rule instanceof CEventIntervalTimeRule)) {
            return;
        }
        try {
            FileWriter file = this.getFile();
            String toWrite = String.valueOf(rule.getName()) + "," + Utils.roundDouble(v, 3) + ",";
            CInterval i = rule.getEnvironment().getInterval();
            toWrite = String.valueOf(toWrite) + i.getBegin() + ",";
            toWrite = String.valueOf(toWrite) + i.getEnd();
            file.write(String.valueOf(toWrite) + "\n");
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

