/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.function.Function;
import org.eclipse.comma.petrinet.PTransition;
import org.eclipse.comma.petrinet.Place;

class Input {
    final Place place;
    final PTransition transition;

    Input(Place place, PTransition transition) {
        this.place = place;
        this.transition = transition;
    }

    String toPython(Function<String, String> variablePrefix) {
        String label = "";
        if (this.place.type == Place.PPlaceType.STATE) {
            label = "Variable('t')";
        } else if (this.place.type == Place.PPlaceType.VARIABLES) {
            label = "Variable('g')";
        } else if (this.place.type == Place.PPlaceType.PARAMETERS) {
            label = "Variable('p')";
        } else if (this.place.type == Place.PPlaceType.CLAUSE || this.place.type == Place.PPlaceType.TRANSITION) {
            label = "Variable('gl')";
        } else {
            throw new RuntimeException("Should not happen");
        }
        return String.format("n.add_input('%s', '%s', %s)\n", this.place.name, this.transition.getPythonName(variablePrefix), label);
    }
}

