/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generator;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.FunctionalConstraintsBlock;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.monitoring.generator.ComponentTimeDataConstraintsGenerator;
import org.eclipse.comma.monitoring.generator.FunctionalConstraintGenerator;
import org.eclipse.comma.monitoring.generator.InfrastructureGenerator;
import org.eclipse.comma.monitoring.generator.InterfaceDecisionGenerator;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.DocumentationGeneratorTask;
import org.eclipse.comma.project.generatortasks.ModelQualityChecksGeneratorTask;
import org.eclipse.comma.project.generatortasks.MonitoringGeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.generatortasks.ReachabilityGraphGeneratorTask;
import org.eclipse.comma.project.generatortasks.SimulatorGeneratorTask;
import org.eclipse.comma.project.generatortasks.TestGeneratorTask;
import org.eclipse.comma.project.generatortasks.UMLGeneratorTask;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationTask;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.project.project.ProjectPackage;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationTask;
import org.eclipse.comma.project.project.SimulatorGenerationTask;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TestGenerationTask;
import org.eclipse.comma.project.project.UMLTask;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CmdLineContext;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ProjectGenerator
extends AbstractGenerator {
    @Inject
    protected IScopeProvider scopeProvider;
    protected OutputLocator outputLocator;
    protected Project project;
    protected Consumer<Task> processTaskConsumer;
    protected List<String> errors = new ArrayList<String>();

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        if (context instanceof CmdLineContext) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            EObject _head = (EObject)IteratorExtensions.head((Iterator)resource.getAllContents());
            this.project = ((ProjectDescription)_head).getProject();
            Set allTasks = IterableExtensions.toSet(this.taskNames());
            Set _requestedTasks = ((CmdLineContext)context).getRequestedTasks();
            boolean bl = _tripleNotEquals = _requestedTasks != null;
            if (_tripleNotEquals) {
                Map<String, Set<String>> dependencies = ProjectUtility.getTaskDependencyMap(this.project);
                HashSet<String> tasksToExecute = ProjectUtility.requiredTasksClosure(((CmdLineContext)context).getRequestedTasks(), dependencies);
                this.generateWithErrorReport(tasksToExecute, fsa, context);
                return;
            }
            Set _excludedTasks = ((CmdLineContext)context).getExcludedTasks();
            boolean bl2 = _tripleNotEquals_1 = _excludedTasks != null;
            if (_tripleNotEquals_1) {
                boolean _not;
                Map<String, Set<String>> dependencies_1 = ProjectUtility.getTaskDependencyMap(this.project);
                Iterable<String> requiredTasks = ProjectUtility.findReferredTasks(((CmdLineContext)context).getExcludedTasks(), dependencies_1);
                boolean _isEmpty = IterableExtensions.isEmpty(requiredTasks);
                boolean bl3 = _not = !_isEmpty;
                if (_not) {
                    ((CmdLineContext)context).setExecutionResult(false);
                    String _join = IterableExtensions.join(requiredTasks, (CharSequence)", ");
                    String _plus = "Tasks " + _join;
                    String _plus_1 = String.valueOf(_plus) + " cannot be skipped.";
                    ((CmdLineContext)context).setErrorString(_plus_1);
                    return;
                }
                allTasks.removeAll(((CmdLineContext)context).getExcludedTasks());
                this.generateWithErrorReport(allTasks, fsa, context);
                return;
            }
            this.generateWithErrorReport(allTasks, fsa, context);
        }
    }

    public List<String> generateWithErrorReport(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        List<String> _xblockexpression = null;
        EObject _head = (EObject)IteratorExtensions.head((Iterator)resource.getAllContents());
        this.project = ((ProjectDescription)_head).getProject();
        _xblockexpression = this.generateWithErrorReport(IterableExtensions.toSet(this.taskNames()), fsa, context);
        return _xblockexpression;
    }

    public List<String> generateWithErrorReport(Resource resource, Set<String> selectedTasks, IFileSystemAccess2 fsa, IGeneratorContext context) {
        List<String> _xblockexpression = null;
        EObject _head = (EObject)IteratorExtensions.head((Iterator)resource.getAllContents());
        this.project = ((ProjectDescription)_head).getProject();
        _xblockexpression = this.generateWithErrorReport(selectedTasks, fsa, context);
        return _xblockexpression;
    }

    private List<String> generateWithErrorReport(final Set<String> tasksToExecute, IFileSystemAccess2 fsa, IGeneratorContext context) {
        boolean _not;
        this.init(tasksToExecute, fsa);
        this.runTasks();
        Functions.Function1<MonitoringTask, Boolean> _function = new Functions.Function1<MonitoringTask, Boolean>(){

            public Boolean apply(MonitoringTask it) {
                return tasksToExecute.contains(it.getName());
            }
        };
        List monitorTasks = IterableExtensions.toList((Iterable)IterableExtensions.filter(ProjectUtility.getMonitorTasks(this.project), (Functions.Function1)_function));
        boolean _isEmpty = monitorTasks.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            try {
                this.generateJavaInfrastructure(monitorTasks, fsa);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    this.errors.add("Errors while generating monitoring code.");
                    this.errors.add(e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        this.createErrorFile(fsa, this.errors);
        System.gc();
        if (context instanceof CmdLineContext) {
            boolean _not_1;
            boolean _isEmpty_1 = this.errors.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                ((CmdLineContext)context).setExecutionResult(false);
                ((CmdLineContext)context).setErrorString("Errors encountered during generation");
            }
        }
        return this.errors;
    }

    public Set<String> getTasksClosure(Resource resource, Set<String> selectedTasks) {
        HashSet<String> _xblockexpression = null;
        EObject _head = (EObject)IteratorExtensions.head((Iterator)resource.getAllContents());
        this.project = ((ProjectDescription)_head).getProject();
        Map<String, Set<String>> dependencies = ProjectUtility.getTaskDependencyMap(this.project);
        _xblockexpression = ProjectUtility.requiredTasksClosure(selectedTasks, dependencies);
        return _xblockexpression;
    }

    public void init(final Set<String> tasksToExecute, final IFileSystemAccess2 fsa) {
        this.errors.clear();
        this.processTaskConsumer = new Consumer<Task>(){

            @Override
            public void accept(Task task) {
                boolean _contains = tasksToExecute.contains(task.getName());
                if (_contains) {
                    ProjectGenerator.this.errors.addAll(ProjectGenerator.this.processTask(task, fsa));
                }
            }
        };
        this.setOutputLocator();
    }

    protected List<String> taskNames() {
        Functions.Function1<Task, String> _function = new Functions.Function1<Task, String>(){

            public String apply(Task it) {
                return it.getName();
            }
        };
        return ListExtensions.map(ProjectUtility.getAllTasks(this.project), (Functions.Function1)_function);
    }

    public List<String> taskNames(Resource res) {
        EObject _head = (EObject)IteratorExtensions.head((Iterator)res.getAllContents());
        Functions.Function1<Task, String> _function = new Functions.Function1<Task, String>(){

            public String apply(Task it) {
                return it.getName();
            }
        };
        return ListExtensions.map(ProjectUtility.getAllTasks(((ProjectDescription)_head).getProject()), (Functions.Function1)_function);
    }

    public void runTasks() {
        ProjectUtility.getMonitorTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getDocumentationTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getUMLTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getReachabilityGraphGeneratorTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getTestGeneratorTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getSimulatorGenerationTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getModelQualityChecksTasks(this.project).forEach(this.processTaskConsumer);
    }

    public void setOutputLocator() {
        OutputLocator _outputLocator;
        this.outputLocator = _outputLocator = new OutputLocator();
    }

    public void createErrorFile(IFileSystemAccess2 fsa, List<String> errors) {
        boolean _not;
        boolean _isEmpty = errors.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            for (String error : errors) {
                _builder.append(error);
                _builder.newLineIfNotEmpty();
            }
            fsa.generateFile("errorReport.txt", (CharSequence)_builder);
        }
    }

    protected List<String> _processTask(MonitoringTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        MonitoringGeneratorTask generatorTask = new MonitoringGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(UMLTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        UMLGeneratorTask generatorTask = new UMLGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(DocumentationGenerationTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        DocumentationGeneratorTask generatorTask = new DocumentationGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(ReachabilityGraphGenerationTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        ReachabilityGraphGeneratorTask generatorTask = new ReachabilityGraphGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(TestGenerationTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        TestGeneratorTask generatorTask = new TestGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(ModelQualityChecksGenerationTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        ModelQualityChecksGeneratorTask generatorTask = new ModelQualityChecksGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(SimulatorGenerationTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        SimulatorGeneratorTask generatorTask = new SimulatorGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    public void generateJavaInfrastructure(List<MonitoringTask> monitorTasks, IFileSystemAccess2 fsa) {
        CommaFileSystemAccess javaFsa = new CommaFileSystemAccess("java/", fsa);
        Set recordTypes = IterableExtensions.toSet((Iterable)StateMachineUtilities.getRecordTypes((EObject)this.project, (IScopeProvider)this.scopeProvider));
        InfrastructureGenerator infrastructureGenerator = new InfrastructureGenerator((IFileSystemAccess)javaFsa, (Iterable)recordTypes);
        infrastructureGenerator.generateRecordsTracker();
        Functions.Function1<EObject, Interface> _function = new Functions.Function1<EObject, Interface>(){

            public Interface apply(EObject it) {
                return (Interface)it;
            }
        };
        Set interfaces = IterableExtensions.toSet((Iterable)ListExtensions.map((List)CommaUtilities.resolveProxy((EObject)this.project, (Iterable)this.scopeProvider.getScope((EObject)this.project, ProjectPackage.Literals.INTERFACE_REFERENCE__INTERFACE).getAllElements()), (Functions.Function1)_function));
        Functions.Function1<EObject, Component> _function_1 = new Functions.Function1<EObject, Component>(){

            public Component apply(EObject it) {
                return (Component)it;
            }
        };
        Set components = IterableExtensions.toSet((Iterable)ListExtensions.map((List)CommaUtilities.resolveProxy((EObject)this.project, (Iterable)this.scopeProvider.getScope((EObject)this.project, ProjectPackage.Literals.COMPONENT_REFERENCE__COMPONENT).getAllElements()), (Functions.Function1)_function_1));
        infrastructureGenerator.generateFactory((Iterable)interfaces, (Iterable)components);
        for (Interface i : interfaces) {
            Signature signature = InterfaceUtilities.getSignature((Interface)i, (IScopeProvider)this.scopeProvider);
            InterfaceDecisionGenerator decisionClassGenerator = new InterfaceDecisionGenerator(signature, i, (IFileSystemAccess)javaFsa);
            decisionClassGenerator.generateUtilityClass();
            decisionClassGenerator.generateConstraintClasses();
            decisionClassGenerator.generateDecisionClass();
        }
        FunctionalConstraintGenerator fcGenerator = new FunctionalConstraintGenerator((Iterable)interfaces, (IFileSystemAccess)javaFsa);
        for (Component c : components) {
            boolean _tripleNotEquals;
            FunctionalConstraintsBlock _functionalConstraintsBlock = c.getFunctionalConstraintsBlock();
            boolean bl = _tripleNotEquals = _functionalConstraintsBlock != null;
            if (_tripleNotEquals) {
                EList _functionalConstraints = c.getFunctionalConstraintsBlock().getFunctionalConstraints();
                for (FunctionalConstraint fc : _functionalConstraints) {
                    fcGenerator.generateUtilityClass(c, fc);
                    fcGenerator.generateConstraintClass(c, fc);
                }
            }
            ComponentTimeDataConstraintsGenerator tdGenerator = new ComponentTimeDataConstraintsGenerator(c, (IFileSystemAccess)javaFsa);
            tdGenerator.generateConstraintClasses();
        }
        Functions.Function1<MonitoringTask, String> _function_2 = new Functions.Function1<MonitoringTask, String>(){

            public String apply(MonitoringTask it) {
                return it.getName();
            }
        };
        infrastructureGenerator.generateScenarioPlayer(ListExtensions.map(monitorTasks, (Functions.Function1)_function_2));
    }

    public List<String> processTask(Task task, IFileSystemAccess2 fsa) {
        if (task instanceof DocumentationGenerationTask) {
            return this._processTask((DocumentationGenerationTask)task, fsa);
        }
        if (task instanceof ModelQualityChecksGenerationTask) {
            return this._processTask((ModelQualityChecksGenerationTask)task, fsa);
        }
        if (task instanceof MonitoringTask) {
            return this._processTask((MonitoringTask)task, fsa);
        }
        if (task instanceof ReachabilityGraphGenerationTask) {
            return this._processTask((ReachabilityGraphGenerationTask)task, fsa);
        }
        if (task instanceof SimulatorGenerationTask) {
            return this._processTask((SimulatorGenerationTask)task, fsa);
        }
        if (task instanceof TestGenerationTask) {
            return this._processTask((TestGenerationTask)task, fsa);
        }
        if (task instanceof UMLTask) {
            return this._processTask((UMLTask)task, fsa);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task, fsa).toString());
    }
}

