/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.impl.PredicateFunctionalConstraintImpl;
import org.eclipse.comma.behavior.component.component.impl.StateBasedFunctionalConstraintImpl;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EClause;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EIConstraint;
import org.eclipse.comma.evaluator.EIState;
import org.eclipse.comma.evaluator.EInterfaceState;
import org.eclipse.comma.evaluator.EPredicateFunctionalConstraint;
import org.eclipse.comma.evaluator.EStateBasedFunctionalConstraint;
import org.eclipse.comma.evaluator.ETransition;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.scoping.IScopeProvider;

public class EComponentState
implements EIState {
    public final List<EAction> actions;
    public final List<EIConstraint> constraints;
    private final Component component;
    public final Map<EConnection, EInterfaceState> connections;
    private final ETransition transition;
    private Map<EClause, EComponentState> possibleClausesLookup;

    public EComponentState(Component component, IScopeProvider scopeProvider, List<EConnection> connections) {
        this(component, new LinkedHashMap<EConnection, EInterfaceState>(), null, null, new ArrayList<EIConstraint>());
        List interfaces = ComponentUtilities.getAllInterfaces((EObject)component.eContainer(), (IScopeProvider)scopeProvider);
        connections.stream().forEach(c -> {
            Port port = component.getPorts().stream().filter(p -> p.getName().equals(eConnection.port)).findFirst().get();
            if (!(port instanceof ProvidedPort)) {
                throw new RuntimeException(String.format("Required ports are not supported (got '%s')", port.getName()));
            }
            Interface itf = interfaces.stream().filter(i -> i.getName().equals(port.getInterface().getName())).findFirst().get();
            this.connections.put((EConnection)c, new EInterfaceState(itf));
        });
        this.constraints.addAll(component.getFunctionalConstraintsBlock().getFunctionalConstraints().stream().map(f -> {
            if (f instanceof StateBasedFunctionalConstraintImpl) {
                return new EStateBasedFunctionalConstraint((StateBasedFunctionalConstraintImpl)f);
            }
            if (f instanceof PredicateFunctionalConstraintImpl) {
                return new EPredicateFunctionalConstraint((PredicateFunctionalConstraintImpl)f);
            }
            throw new RuntimeException("Not supported");
        }).filter(c -> !c.usesRequiredPort((List<Port>)component.getPorts())).collect(Collectors.toList()));
    }

    private EComponentState(Component component, LinkedHashMap<EConnection, EInterfaceState> connections, ETransition transition, List<EAction> actions, List<EIConstraint> constraints) {
        this.component = component;
        this.connections = connections;
        this.transition = transition;
        this.actions = actions;
        this.constraints = constraints;
    }

    @Override
    public int countStates() {
        return this.connections.values().stream().map(i -> i.countStates()).reduce(0, Integer::sum);
    }

    @Override
    public int countClauses() {
        return this.connections.values().stream().map(i -> i.countClauses()).reduce(0, Integer::sum);
    }

    @Override
    public List<ETransition> possibleTransitions() {
        if (this.transition != null) {
            throw new RuntimeException("Taking transition not allowed");
        }
        ArrayList<ETransition> transitions = new ArrayList<ETransition>();
        for (Map.Entry<EConnection, EInterfaceState> entry : this.connections.entrySet()) {
            for (ETransition transition : entry.getValue().possibleTransitions()) {
                transition.connection = entry.getKey();
                transitions.add(transition);
            }
        }
        return transitions;
    }

    @Override
    public boolean isTransitionPossibleWithParameters(ETransition transition, EVariableCollection triggerParameters) {
        return this.isTransitionPossibleWithParametersInternal(transition, triggerParameters) != null;
    }

    private EComponentState isTransitionPossibleWithParametersInternal(ETransition transition, EVariableCollection triggerParameters) {
        if (!this.possibleTransitions().stream().anyMatch(t -> t.transition == eTransition.transition && t.connection == eTransition.connection)) {
            return null;
        }
        LinkedHashMap<EConnection, EInterfaceState> ports = new LinkedHashMap<EConnection, EInterfaceState>(this.connections);
        if (!ports.get(transition.connection).isTransitionPossibleWithParameters(transition, triggerParameters)) {
            return null;
        }
        ports.put(transition.connection, ports.get(transition.connection).takeTransition(transition, triggerParameters));
        ports.get((Object)transition.connection).actions.forEach(a -> {
            EConnection eConnection = a.connection = eTransition.connection;
        });
        List<EAction> actions = ports.get((Object)transition.connection).actions;
        EComponentState next = new EComponentState(this.component, ports, transition, actions, new ArrayList<EIConstraint>(this.constraints));
        boolean constraintFailed = EComponentState.checkAndTakeConstraints(this, next);
        return constraintFailed ? null : next;
    }

    @Override
    public EComponentState takeTransition(ETransition transition, EVariableCollection triggerParameters) {
        EComponentState next = this.isTransitionPossibleWithParametersInternal(transition, triggerParameters);
        if (next == null) {
            throw new RuntimeException("Not allowed transition");
        }
        return next;
    }

    private static boolean checkAndTakeConstraints(EComponentState current, EComponentState next) {
        boolean constraintFailed = false;
        block0: for (EAction action : next.actions) {
            for (EIConstraint constraint : next.constraints) {
                if (!constraintFailed && constraint.isAllowed(current, next, action)) {
                    next.constraints.set(next.constraints.indexOf(constraint), constraint.take(current, next, action));
                    continue;
                }
                constraintFailed = true;
                break block0;
            }
        }
        return constraintFailed;
    }

    @Override
    public List<EClause> possibleClauses() {
        if (this.transition == null) {
            throw new RuntimeException("Taking clause not allowed");
        }
        EInterfaceState state = this.connections.get(this.transition.connection);
        this.possibleClausesLookup = new LinkedHashMap<EClause, EComponentState>();
        for (EClause clause : state.possibleClauses()) {
            clause = new EClause(clause.clause, this.transition);
            EComponentState next = this.takeClauseInternal(clause);
            boolean constraintFailed = EComponentState.checkAndTakeConstraints(this, next);
            if (constraintFailed) continue;
            this.possibleClausesLookup.put(clause, next);
        }
        return this.possibleClausesLookup.keySet().stream().collect(Collectors.toList());
    }

    @Override
    public EComponentState takeClause(EClause clause) {
        if (this.possibleClausesLookup == null || !this.possibleClausesLookup.containsKey(clause)) {
            throw new RuntimeException("Taking clause not allowed");
        }
        return this.possibleClausesLookup.get(clause);
    }

    private EComponentState takeClauseInternal(EClause clause) {
        LinkedHashMap<EConnection, EInterfaceState> ports = new LinkedHashMap<EConnection, EInterfaceState>(this.connections);
        ArrayList<EIConstraint> constraints = new ArrayList<EIConstraint>(this.constraints);
        ports.put(this.transition.connection, ports.get(this.transition.connection).takeClause(clause));
        ports.get((Object)this.transition.connection).actions.forEach(a -> {
            EConnection eConnection = a.connection = this.transition.connection;
        });
        return new EComponentState(this.component, ports, null, ports.get((Object)this.transition.connection).actions, new ArrayList<EIConstraint>(constraints));
    }

    @Override
    public List<State> getStates() {
        return this.connections.values().stream().map(i -> i.getStates()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<EAction> getActions() {
        return this.actions;
    }

    @Override
    public boolean inTransition() {
        return this.transition != null;
    }

    @Override
    public State getState(StateMachine machine) {
        return this.connections.values().stream().map(c -> c.getState(machine)).filter(c -> c != null).findFirst().get();
    }
}

