/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.List;
import org.eclipse.comma.monitoring.lib.CComponentTypeDescriptor;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.CMonitoringContext;
import org.eclipse.comma.monitoring.lib.CPortConnectionMonitoringContext;

public class CComponentMonitoringContext
extends CMonitoringContext {
    protected String componentType;
    protected List<String> componentInstancesInTrace;
    protected String componentInstanceName;
    protected CComponentTypeDescriptor componentDescriptor;

    public CComponentMonitoringContext(CComponentTypeDescriptor componentDescriptor, List<String> componentInstancesInTrace, CFactory factory, String resultsDir) {
        super(factory, resultsDir);
        this.componentDescriptor = componentDescriptor;
        this.componentInstancesInTrace = componentInstancesInTrace;
    }

    public CComponentTypeDescriptor getComponentTypeDescriptor() {
        return this.componentDescriptor;
    }

    public CComponentMonitoringContext clone() {
        CComponentMonitoringContext context = new CComponentMonitoringContext(this.componentDescriptor, this.componentInstancesInTrace, this.factory, this.resultsDir);
        context.skipTimeConstraints(this.timeConstraintsSkipped);
        context.skipDataConstraints(this.dataConstraintsSkipped);
        return context;
    }

    public boolean isComponentInstance(String id) {
        return this.componentInstancesInTrace.contains(id);
    }

    public boolean isSingletonPort(String port) {
        return this.componentDescriptor.singletonPorts.contains(port);
    }

    public CPortConnectionMonitoringContext createPortConnectionContext(String interfaceName, String port, String componentInstance, String connectionKey) {
        CPortConnectionMonitoringContext result = new CPortConnectionMonitoringContext(interfaceName, false, this.factory, this.resultsDir);
        result.setConnectionName(connectionKey).setLocalDir(String.valueOf(componentInstance) + "/" + "port_" + port + "/");
        result.setPort(port);
        return result;
    }

    public CInterfaceMonitoringContext createComponentTimeDataContext() {
        CInterfaceMonitoringContext context = new CInterfaceMonitoringContext("", false, null, this.resultsDir).setConnectionName(this.componentInstanceName).setLocalDir(String.valueOf(this.componentInstanceName) + "/" + "time_data/");
        context.skipTimeConstraints(this.timeConstraintsSkipped);
        context.skipDataConstraints(this.dataConstraintsSkipped);
        return context;
    }

    public String getComponentInstanceName() {
        return this.componentInstanceName;
    }

    public CComponentMonitoringContext setComponentInstanceName(String name) {
        this.componentInstanceName = name;
        return this;
    }

    public String getResultsFile(String constraintName) {
        return String.valueOf(this.resultsDir) + this.componentInstanceName + "/" + constraintName + "/" + this.componentInstanceName + "_" + constraintName + "_results.txt";
    }

    public String getTraceFile(String constraintName) {
        return String.valueOf(this.resultsDir) + this.componentInstanceName + "/" + constraintName + "/" + this.componentInstanceName + "_" + constraintName + "_trace.txt";
    }

    public String getErrorUMLFile(String constraintName) {
        return String.valueOf(this.resultsDir) + this.componentInstanceName + "/" + constraintName + "/" + this.componentInstanceName + "_" + constraintName + "_error_sequence_diagram.plantuml";
    }
}

