/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.interfaces.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.ExpressionPackage;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class InterfaceUtilities {
    public static Iterable<Signature> getSignatures(EList<Interface> interfaces, final IScopeProvider scopeProvider) {
        return Iterables.transform(interfaces, (Function)new Function<Interface, Signature>(){

            public Signature apply(Interface i) {
                return InterfaceUtilities.getSignature(i, scopeProvider);
            }
        });
    }

    public static Signature getSignature(Interface context, IScopeProvider scopeProvider) {
        List<Signature> signatures = InterfaceUtilities.getSignatures(context, scopeProvider);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(signatures);
        if (_isNullOrEmpty) {
            return null;
        }
        return signatures.get(0);
    }

    public static List<Signature> getSignatures(Interface context, IScopeProvider scopeProvider) {
        return CommaUtilities.resolveProxy((EObject)context, (Iterable)scopeProvider.getScope((EObject)context, ExpressionPackage.Literals.INTERFACE_AWARE_TYPE__INTERFACE).getAllElements());
    }
}

