/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.list;

import java.util.Iterator;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.ParallelListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.list.ListMultimap;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ListIterableBatch;
import org.eclipse.collections.impl.lazy.parallel.list.ParallelFlatCollectListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.RootListBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class ListIterableParallelIterable<T>
extends AbstractParallelListIterable<T, RootListBatch<T>> {
    private final ListIterable<T> delegate;
    private final ExecutorService executorService;
    private final int batchSize;

    public ListIterableParallelIterable(ListIterable<T> delegate, ExecutorService executorService, int batchSize) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException();
        }
        if (!(delegate instanceof RandomAccess)) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.executorService = executorService;
        this.batchSize = batchSize;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public LazyIterable<RootListBatch<T>> split() {
        return new ListIterableParallelBatchLazyIterable();
    }

    public void forEach(Procedure<? super T> procedure) {
        AbstractParallelIterable.forEach(this, procedure);
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return AbstractParallelIterable.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return AbstractParallelIterable.allSatisfy(this, predicate);
    }

    public T detect(Predicate<? super T> predicate) {
        return AbstractParallelIterable.detect(this, predicate);
    }

    @Override
    public <V> ParallelListIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectListIterable(this, function);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toArray((Object[])array);
    }

    @Override
    public <V> ListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.delegate.groupBy(function);
    }

    @Override
    public <V> ListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.delegate.groupByEach(function);
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.delegate.groupByUniqueKey(function);
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIterableParallelBatchLazyIterable
    extends AbstractLazyIterable<RootListBatch<T>> {
        private ListIterableParallelBatchLazyIterable() {
        }

        public void each(Procedure<? super RootListBatch<T>> procedure) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RootListBatch chunk = iterator.next();
                procedure.value(chunk);
            }
        }

        public Iterator<RootListBatch<T>> iterator() {
            return new ListIterableParallelBatchIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIterableParallelBatchIterator
    implements Iterator<RootListBatch<T>> {
        protected int chunkIndex;

        private ListIterableParallelBatchIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.chunkIndex * ListIterableParallelIterable.this.getBatchSize() < ListIterableParallelIterable.this.delegate.size();
        }

        @Override
        public RootListBatch<T> next() {
            int chunkStartIndex = this.chunkIndex * ListIterableParallelIterable.this.getBatchSize();
            int chunkEndIndex = (this.chunkIndex + 1) * ListIterableParallelIterable.this.getBatchSize();
            int truncatedChunkEndIndex = Math.min(chunkEndIndex, ListIterableParallelIterable.this.delegate.size());
            ++this.chunkIndex;
            return new ListIterableBatch(ListIterableParallelIterable.this.delegate, chunkStartIndex, truncatedChunkEndIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot call remove() on " + ListIterableParallelIterable.this.delegate.getClass().getSimpleName());
        }
    }
}

