-----------------------------------------------------------------------
--           This file was automatically generated by the            --
--                                                                   --
--                Ada infrastructural code generator                 -- 
--                  for the CHESS component model                    --
--                                                                   --
--                   Copyright (C) 2011-2012                         --
--                 University of Padova, ITALY                       --
--                                                                   --
-- Author: Marco Panunzio         panunzio@math.unipd.it             --
--                                                                   --
-- All rights reserved. This program and the accompanying materials  --
-- are made available under the terms of the Eclipse Public License  --
-- v1.0 which accompanies this distribution, and is available at     --
-- http://www.eclipse.org/legal/epl-v10.html                         --
-----------------------------------------------------------------------

-- Comment the with below if you do not use user-defined datatypes
with Datatype; use Datatype;

-- with of interface and component implementation packages
with Producer_IF;
with Consumer_IF;
with Store_IF;
with Producers.Producer_impls;

--with of packages for enforcement of extra-functional properties
with Ada.Real_Time; use Ada.Real_Time;
with Data_Structure;
with Container_Protection; use Container_Protection;
with Cyclic_Task;


package CT_SwSystem_Producer_insts is 
 
   procedure Initialize_Container;

   -- Getter subprograms for provided interfaces
   function Get_Producer_IF return Producer_IF.Producer_IF_ptr;
 

   -- Setter subprograms for required interfaces
   procedure Set_Consumer_IF_RI (ptr : in Consumer_IF.Consumer_IF_ptr);
   procedure Set_Store_IF_RI (ptr : in Store_IF.Store_IF_ptr);

private
   
   -- Component instance
   SwSystem_Producer_inst: aliased Producers.Producer_impls.Producer_impl;
   -- Access pointers to the instance (1 x PI)
   SwSystem_Producer_inst_as_Producer_IF_ptr : Producer_IF.Producer_IF_ptr := SwSystem_Producer_inst'access;
   
   -- Type definition for the container
   type CT_SwSystem_Producer_inst_T is new Producer_IF.Producer_IF with null record;

   -- Overriding of operations of interfaces

   overriding 
   procedure Produce (Self : in out CT_SwSystem_Producer_inst_T) is null;

   -- Instantiation of the container
   CT_SwSystem_Producer_inst_T_inst_0 : aliased CT_SwSystem_Producer_inst_T;
   


   -- Entities for the enforcement of extra-functional properties --
   
   -- Wrapper procedure for the cyclic operation
   procedure Produce;

   procedure Enqueueing_Procedure_My_Thread_0 (Release : out Time);

   My_CPA_0 : aliased Release_Control_OBCS(4);

   My_Thread_0 : aliased Cyclic_Task.Thread_T(Data_Structure.Generate_Task_ID, 4, 0, 125,
                                  Enqueueing_Procedure_My_Thread_0'access,
                                  Produce'access);

end CT_SwSystem_Producer_insts;
