/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.StreamingLogToken;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.cft.server.ui.internal.console.ConsoleStream;
import org.eclipse.cft.server.ui.internal.console.SingleConsoleStream;
import org.eclipse.cft.server.ui.internal.console.UILogConfig;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ApplicationLogConsoleStream
extends ConsoleStream {
    protected static final LogContentType APPLICATION_LOG_STS_ERROR = new LogContentType("applicationlogstderror");
    protected static final LogContentType APPLICATION_LOG_STD_OUT = new LogContentType("applicationlogstdout");
    protected static final LogContentType APPLICATION_LOG_UNKNOWN = new LogContentType("applicationlogunknown");
    private StreamingLogToken loggregatorToken;
    private Map<LogContentType, ConsoleStream> logStreams = new HashMap<LogContentType, ConsoleStream>();
    private ConsoleConfig consoleDescriptor;

    @Override
    public synchronized void close() {
        if (this.logStreams != null) {
            for (Map.Entry<LogContentType, ConsoleStream> entry : this.logStreams.entrySet()) {
                entry.getValue().close();
            }
            this.logStreams.clear();
        }
        if (this.loggregatorToken != null) {
            this.loggregatorToken.cancel();
            this.loggregatorToken = null;
        }
    }

    @Override
    public synchronized void initialiseStream(ConsoleConfig descriptor) throws CoreException {
        if (descriptor == null) {
            throw CloudErrorUtil.toCoreException((String)Messages.ERROR_FAILED_INITIALISE_APPLICATION_LOG_STREAM);
        }
        this.consoleDescriptor = descriptor;
        if (this.loggregatorToken == null) {
            CloudFoundryServerBehaviour behaviour = this.consoleDescriptor.getCloudServer().getBehaviour();
            this.loggregatorToken = behaviour.addApplicationLogListener(this.consoleDescriptor.getCloudApplicationModule().getDeployedApplicationName(), (ApplicationLogListener)new ApplicationLogConsoleListener());
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.loggregatorToken != null;
    }

    @Override
    protected IOConsoleOutputStream getOutputStream(LogContentType type) {
        ConsoleStream consoleStream = this.getApplicationLogStream(type);
        if (consoleStream != null && consoleStream.isActive()) {
            return consoleStream.getOutputStream(type);
        }
        return null;
    }

    protected static String format(String message) {
        if (message.contains("\n") || message.contains("\r")) {
            return message;
        }
        return String.valueOf(message) + '\n';
    }

    protected synchronized ConsoleStream getApplicationLogStream(LogContentType type) {
        if (type == null) {
            return null;
        }
        ConsoleStream stream = this.logStreams.get(type);
        if (stream == null) {
            int swtColour = -1;
            if (APPLICATION_LOG_STS_ERROR.equals((Object)type)) {
                swtColour = 3;
            } else if (APPLICATION_LOG_STD_OUT.equals((Object)type)) {
                swtColour = 6;
            } else if (APPLICATION_LOG_UNKNOWN.equals((Object)type)) {
                swtColour = 2;
            }
            if (swtColour > -1) {
                try {
                    stream = new SingleConsoleStream(new UILogConfig(swtColour));
                    stream.initialiseStream(this.consoleDescriptor);
                    this.logStreams.put(type, stream);
                }
                catch (CoreException e) {
                    CloudFoundryPlugin.logError((Throwable)e);
                }
            }
        }
        return stream;
    }

    public CloudLog getCloudlog(ApplicationLog appLog) {
        if (appLog == null) {
            return null;
        }
        ApplicationLog.MessageType type = appLog.getMessageType();
        LogContentType contentType = APPLICATION_LOG_UNKNOWN;
        if (type != null) {
            switch (type) {
                case STDERR: {
                    contentType = APPLICATION_LOG_STS_ERROR;
                    break;
                }
                case STDOUT: {
                    contentType = APPLICATION_LOG_STD_OUT;
                }
            }
        }
        return new CloudLog(ApplicationLogConsoleStream.format(appLog.getMessage()), contentType);
    }

    public synchronized void write(ApplicationLog appLog) throws CoreException {
        if (appLog == null) {
            return;
        }
        CloudLog log = this.getCloudlog(appLog);
        IOConsoleOutputStream activeOutStream = this.getOutputStream(log.getLogType());
        if (activeOutStream != null && log.getMessage() != null) {
            try {
                activeOutStream.write(log.getMessage());
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException((Throwable)e);
            }
        }
    }

    public class ApplicationLogConsoleListener
    implements ApplicationLogListener {
        public void onMessage(ApplicationLog appLog) {
            if (ApplicationLogConsoleStream.this.isActive()) {
                try {
                    ApplicationLogConsoleStream.this.write(appLog);
                }
                catch (CoreException e) {
                    this.onError(e);
                }
            }
        }

        public void onComplete() {
        }

        public void onError(Throwable exception) {
            if (ApplicationLogConsoleStream.this.isActive()) {
                CloudFoundryPlugin.logError((String)NLS.bind((String)Messages.ERROR_APPLICATION_LOG, (Object)ApplicationLogConsoleStream.this.consoleDescriptor.getCloudApplicationModule().getDeployedApplicationName(), (Object)exception.getMessage()), (Throwable)exception);
            }
        }
    }
}

