/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.rse.internal.CloudFoundryRsePlugin;
import org.eclipse.cft.server.rse.internal.Messages;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;

public class ApplicationSubSystem
extends FileServiceSubSystem
implements CloudServerListener,
IServerListener,
IServerLifecycleListener {
    public ApplicationSubSystem(IHost host, IConnectorService connectorService, IFileService hostFileService, IHostFileToRemoteFileAdapter fileAdapter, ISearchService searchService) {
        super(host, connectorService, hostFileService, fileAdapter, searchService);
        this.supportsConnecting = false;
        host.setOffline(true);
        this.addServerListeners();
    }

    public String getDescription() {
        return Messages.ApplicationSubSystem_DESCRIPTION;
    }

    public void serverAdded(IServer server) {
        if (CloudFoundryRsePlugin.doesServerBelongToHost(server, this.getHost())) {
            server.addServerListener((IServerListener)this);
            this.fireEventChangeChildren();
        }
    }

    public void serverChanged(CloudServerEvent event) {
        int type = event.getType();
        if (type == 100) {
            this.fireEventChangeChildren();
        }
    }

    public void serverChanged(IServer server) {
        if (CloudFoundryRsePlugin.doesServerBelongToHost(server, this.getHost())) {
            this.fireEventChangeChildren();
        }
    }

    public void serverChanged(ServerEvent event) {
        if (CloudFoundryRsePlugin.doesServerBelongToHost(event.getServer(), this.getHost()) && (event.getKind() & 0x20) != 0 && (event.getKind() & 1) != 0 && (event.getState() == 2 || event.getState() == 4)) {
            this.fireEventChangeChildren();
        }
    }

    public void serverRemoved(IServer server) {
        if (CloudFoundryRsePlugin.doesServerBelongToHost(server, this.getHost())) {
            server.removeServerListener((IServerListener)this);
            this.fireEventChangeChildren();
        }
    }

    private void addServerListeners() {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            IServer candidate = servers[i];
            if (CloudFoundryRsePlugin.doesServerBelongToHost(candidate, this.getHost())) {
                candidate.addServerListener((IServerListener)this);
            }
            ++i;
        }
    }

    private void fireEventChangeChildren() {
        this.fireEvent(new SystemResourceChangeEvent(null, 95, (Object)this));
    }
}

